% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrt2d_svc.R
\name{lrt2d_svc}
\alias{lrt2d_svc}
\title{Unbiased modified likelihood ratio test for simple separability of a variance-covariance matrix.}
\usage{
lrt2d_svc(
  formula_2d,
  subject,
  data_2d = list(),
  eps,
  maxiter,
  startmat,
  sign.level,
  n.simul
)
}
\arguments{
\item{formula_2d}{value2d~Id1+Id2}

\item{subject}{the replicate, also called the subject or individual, the
first column in the matrix (2d) data file}

\item{data_2d}{the name of the matrix data}

\item{eps}{the threshold in the stopping criterion for the iterative mle
algorithm (estimation)}

\item{maxiter}{the maximum number of iterations for the mle algorithm (estimation)}

\item{startmat}{the value of the second factor variance-covariance matrix
used for initialization, i.e., to start the mle algorithm (estimation) and
obtain the initial estimate of the first factor variance-covariance matrix}

\item{sign.level}{the significance level, or rejection rate in the testing of
the null hypothesis of simple separability for a variance-covariance
structure, when the unbiased modified LRT is used, i.e., the critical value
in the chi-square test is derived by simulations from the sampling distribution
of the LRT statistic}

\item{n.simul}{the number of simulations used to build the sampling distribution
of the LRT statistic under the null hypothesis, using the same characteristics as the
i.i.d. random sample from a matrix normal distribution}
}
\description{
A likelihood ratio test (LRT) for simple separability of a
variance-covariance matrix, modified to be unbiased in finite samples. The
modification is a penalty-based homothetic transformation of the LRT
statistic. The penalty value is optimized for a given mean model, which is
left unstructured here. In the required function, the Id1 and Id2 variables
correspond to the row and column subscripts, and are the second and third
columns in the matrix (2d) data file, respectively; \dQuote{value2d} refers to
the observed variable, and is the fourth column in the matrix data file.
}
\section{Output}{


\dQuote{Convergence}, TRUE or FALSE

\dQuote{chi.df}, the theoretical number of degrees of freedom of the
asymptotic chi-square distribution that would apply to the unmodified
LRT statistic for simple
separability of a variance-covariance structure

\dQuote{Lambda}, the observed value of the unmodified LRT statistic

\dQuote{critical.value}, the critical value at the specified significance
level for the chi-square distribution with \dQuote{chi.df} degrees of freedom

\dQuote{Decision.lambda} will indicate whether or not the null hypothesis of
separability was rejected, based on the theoretical LRT statistic

\dQuote{Simulation.critical.value}, the critical value at the specified
significance level that is derived from the sampling distribution of the
unbiased modified LRT statistic

\dQuote{Decision.lambda.simulation}, the decision (acceptance/rejection)
regarding the null hypothesis of simple separability, made using the
theoretical (biased unmodified) LRT

\dQuote{Penalty}, the optimized penalty value used in the homothetic
transformation between the biased unmodified and unbiased modified LRT statistics

\dQuote{U1hat}, the estimated variance-covariance matrix for the rows

\dQuote{Standardized_U1hat}, the standardized estimated variance-covariance
matrix for the rows; the standardization is performed by dividing each
entry of U1hat by entry(1, 1) of U1hat

\dQuote{U2hat}, the estimated variance-covariance matrix for the columns

\dQuote{Standardized_U2hat}, the standardized estimated variance-covariance
matrix for the columns; the standardization is performed by multiplying
each entry of U2hat by entry(1, 1) of U1hat

\dQuote{Shat}, the sample variance-covariance matrix computed from the
vectorized data matrices
}

\section{References}{


Manceur AM, Dutilleul P. 2013. Unbiased modified likelihood ratio tests for simple and double
separability of a variance-covariance structure. Statistics
and Probability Letters 83: 631-636.
}

\examples{
output <- lrt2d_svc(value2d~Id1+Id2, subject = "K", data_2d = data2d, n.simul = 100)
output

}
