% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eno.R
\name{Eno}
\alias{Eno}
\title{Computes Effective Sample Size With Classical Method}
\usage{
Eno(obs, posdim)
}
\arguments{
\item{obs}{Matrix of any number of dimensions up to 10.}

\item{posdim}{Dimension along which to compute the effective sample size.}
}
\value{
Same dimensions as var but without the posdim dimension.
}
\description{
Computes the effective number of independent values along the posdim 
dimension of a matrix.\cr
This effective number of independent observations can be used in 
statistical/inference tests.\cr
Based on eno function from Caio Coelho from rclim.txt.
}
\examples{
# See examples on Load() to understand the first lines in this example
 \dontrun{
data_path <- system.file('sample_data', package = 's2dverification')
exp <- list(
        name = 'experiment',
        path = file.path(data_path, 'model/$EXP_NAME$/monthly_mean',
                         '$VAR_NAME$_3hourly/$VAR_NAME$_$START_DATES$.nc')
      )
obs <- list(
        name = 'observation',
        path = file.path(data_path, 'observation/$OBS_NAME$/monthly_mean',
                         '$VAR_NAME$/$VAR_NAME$_$YEAR$$MONTH$.nc')
      )
# Now we are ready to use Load().
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- Load('tos', list(exp), list(obs), startDates,
                  leadtimemin = 1, leadtimemax = 4, output = 'lonlat',
                  latmin = 27, latmax = 48, lonmin = -12, lonmax = 40)
 }
 \dontshow{
startDates <- c('19851101', '19901101', '19951101', '20001101', '20051101')
sampleData <- s2dverification:::.LoadSampleData('tos', c('experiment'), 
                                               c('observation'), startDates,
                                               output = 'lonlat', 
                                               latmin = 27, latmax = 48, 
                                               lonmin = -12, lonmax = 40) 
 }
sampleData$mod <- Season(sampleData$mod, 4, 11, 1, 12)
eno <- Eno(sampleData$mod[1, 1, , 1, , ], 1)
PlotEquiMap(eno, sampleData$lon, sampleData$lat)

}
\author{
History:\cr
0.1  -  2011-05  (V. Guemas, \email{virginie.guemas at ic3.cat})  -  Original code\cr
1.0  -  2013-09  (N. Manubens, \email{nicolau.manubens at ic3.cat})  -  Formatting to R CRAN
}
\keyword{datagen}
