% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicop_methods.R
\name{bicop_distributions}
\alias{bicop_distributions}
\alias{dbicop}
\alias{pbicop}
\alias{rbicop}
\alias{hbicop}
\alias{dbicop_dist}
\alias{pbicop_dist}
\alias{rbicop_dist}
\alias{hbicop_dist}
\alias{pbicop}
\alias{rbicop}
\alias{hbicop}
\title{Bivariate copula distributions}
\usage{
dbicop(u, family, rotation, parameters)

pbicop(u, family, rotation, parameters)

rbicop(n, family, rotation, parameters, U = NULL)

hbicop(u, cond_var, family, rotation, parameters, inverse = FALSE)
}
\arguments{
\item{u}{evaluation points, either a length 2 vector or a two-column matrix.}

\item{family}{the copula family, a string containing the family name (see
\code{\link{bicop}} for all possible families).}

\item{rotation}{the rotation of the copula, one of \code{0}, \code{90}, \code{180}, \code{270}.}

\item{parameters}{a vector or matrix of copula parameters.}

\item{n}{number of observations. If `length(n) > 1``, the length is taken to
be the number required.}

\item{U}{optionally, an \eqn{n \times 2} matrix of values in \eqn{(0,1)}.
The result is then the inverse Rosenblatt transform of \code{U}; if \code{U} is a
matrix of independent \eqn{U(0, 1)} variables, this simulates data
from \code{vinecop}.}

\item{cond_var}{either \code{1} or \code{2}; \code{cond_var = 1} conditions on the first
variable, \code{cond_var = 2} on the second.}

\item{inverse}{whether to compute the h-function or its inverse.}
}
\value{
\code{dbicop()} gives the density, \code{pbicop()} gives the distribution function,
\code{rbicop()} generates random deviates, and \code{hbicop()} gives the h-functions
(and their inverses).

The length of the result is determined by \code{n} for \code{rbicop()}, and
the number of rows in \code{u} for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the
result.
}
\description{
Density, distribution function, random generation and h-functions (with
their inverses) for the bivariate copula distribution.
}
\details{
See \link{bicop} for the various implemented copula families.

H-functions (\code{hbicop()}) are conditional distributions derived
from a copula. If \eqn{C(u, v) = P(U \le u, V \le v)} is a copula, then
\deqn{h_1(v | u) = P(U \le u | V = v),} \deqn{h_2(u | v) = P(V \le v | U =
u).}
}
\note{
The functions can optionally be used with a \link{bicop_dist}
object, e.g., \code{dbicop(c(0.1, 0.5), bicop_dist("indep"))}.
}
\examples{
## evaluate the copula density
dbicop(c(0.1, 0.2), "clay", 90, 3)
dbicop(c(0.1, 0.2), bicop_dist("clay", 90, 3))

## evaluate the copula cdf
pbicop(c(0.1, 0.2), "clay", 90, 3)

## simulate data
plot(rbicop(500, "clay", 90, 3))

## h-functions
joe_cop <- bicop_dist("joe", 0, 3)
# h_1(0.2 | 0.1)
hbicop(c(0.1, 0.2), 1, "bb8", 0, c(2, 0.5))
# h_2(0.1 | 0.2)
hbicop(c(0.1, 0.2), 2, joe_cop)
# h_1^{-1}(0.2 | 0.1)
hbicop(c(0.1, 0.2), 1, "bb8", 0, c(2, 0.5), inverse = TRUE)
# h_2^{-1}(0.1 | 0.2)
hbicop(c(0.1, 0.2), 2, joe_cop, inverse = TRUE)
}
