% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dgeom_rvec}
\alias{dgeom_rvec}
\alias{pgeom_rvec}
\alias{qgeom_rvec}
\alias{rgeom_rvec}
\title{The Geometric Distribution, Using Multiple Draws}
\usage{
dgeom_rvec(x, prob, log = FALSE)

pgeom_rvec(q, prob, lower.tail = TRUE, log.p = FALSE)

qgeom_rvec(p, prob, lower.tail = TRUE, log.p = FALSE)

rgeom_rvec(n, prob, n_draw = NULL)
}
\arguments{
\item{x}{Quantiles. Can be an rvec.}

\item{prob}{Probability of
success in each trial.
See \code{\link[stats:Geometric]{stats::dgeom()}}.
Can be an rvec.}

\item{log, log.p}{Whether to return results
on a log scale. Default is
\code{FALSE}. Cannot be an rvec.}

\item{q}{Quantiles. Can be an rvec.}

\item{lower.tail}{Whether to return
\eqn{P[X \le x]}, as opposed to
\eqn{P[X > x]}. Default is \code{TRUE}.
Cannot be an rvec.}

\item{p}{Probabilities. Can be an rvec.}

\item{n}{The length of random vector being
created. Cannot be an rvec.}

\item{n_draw}{Number of random draws
in the random vector being
created. Cannot be an rvec.}
}
\value{
\itemize{
\item If any of the arguments are rvecs,
or if a value for \code{n_draw} is supplied,
then an \link[=rvec]{rvec}
\item Otherwise an ordinary R vector.
\item \code{rgeom_rvec()} always returns doubles (not integers).
}
}
\description{
Density, distribution function,
quantile function and random generation for the
geometric distribution, modified to work with
rvecs.
}
\details{
Functions \code{dgeom_rvec()}, \code{pgeom_rvec()},
\code{pgeom_rvec()} and \code{rgeom_rvec()} work like
base R functions \code{\link[=dgeom]{dgeom()}}, \code{\link[=pgeom]{pgeom()}},
\code{\link[=qgeom]{qgeom()}}, and \code{\link[=rgeom]{rgeom()}}, except that
they accept rvecs as inputs. If any
input is an rvec, then the output will be too.
Function \code{rgeom_rvec()} also returns an
rvec if a value for \code{n_draw} is supplied.

\code{dgeom_rvec()}, \code{pgeom_rvec()},
\code{pgeom_rvec()} and \code{rgeom_rvec()}
use \link[vctrs:theory-faq-recycling]{tidyverse}
vector recycling rules:
\itemize{
\item Vectors of length 1 are recycled
\item All other vectors must have the same size
}
}
\section{Warning}{


From version rvec version 0.7.4 onwards,
\code{rgeom_rvec()} always returns doubles (not integers).
}

\examples{
x <- rvec(list(c(3, 5),
               c(0, 2)))
dgeom_rvec(x, prob = 0.3)
pgeom_rvec(x, prob = 0.3)

rgeom_rvec(n = 2,
           prob = c(0.5, 0.8),
           n_draw = 1000)
}
\seealso{
\itemize{
\item \code{\link[=dgeom]{dgeom()}}
\item \code{\link[=pgeom]{pgeom()}}
\item \code{\link[=qgeom]{qgeom()}}
\item \code{\link[=rgeom]{rgeom()}}
\item \link[stats:Distributions]{stats::distributions}.
}
}
