% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoencoder_variational.R
\name{loss_variational}
\alias{loss_variational}
\title{Variational loss}
\usage{
loss_variational(reconstruction_loss)
}
\arguments{
\item{reconstruction_loss}{Another loss to be used as reconstruction error (e.g. "binary_crossentropy")}
}
\value{
A \code{"ruta_loss"} object
}
\description{
Specifies an evaluation function adapted to the variational autoencoder. It combines
a base reconstruction error and the Kullback-Leibler divergence between the learned
distribution and the true latent posterior.
}
\references{
\itemize{
\item \href{https://arxiv.org/abs/1312.6114}{Auto-Encoding Variational Bayes}
\item \href{http://blog.fastforwardlabs.com/2016/08/22/under-the-hood-of-the-variational-autoencoder-in.html}{Under the Hood of the Variational Autoencoder (in Prose and Code)}
\item \href{https://keras.rstudio.com/articles/examples/variational_autoencoder.html}{Keras example: Variational autoencoder}
}
}
\seealso{
\code{\link{autoencoder_variational}}

Other loss functions: \code{\link{contraction}},
  \code{\link{correntropy}}
}
\concept{loss functions}
