% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSymbols.Gigapack.R
\name{getSymbols.Gigapack}
\alias{getSymbols.Gigapack}
\title{Download Giga Candles data from GigaPack}
\usage{
getSymbols.Gigapack(
  Symbols,
  env = globalenv(),
  from = Sys.Date() - 30,
  to = Sys.Date(),
  date = "",
  verbose = TRUE,
  field = "",
  type = "candles",
  fake = FALSE,
  reps = 1,
  trim = 0.1,
  auto.assign = FALSE,
  ...
)
}
\arguments{
\item{Symbols}{a character vector of AlgoPack symbols to download data for.}

\item{env}{environment where to create the downloaded data object.}

\item{from}{a character string indicating the start date of the data to download, in YYYY-MM-DD format.}

\item{to}{a character string indicating the end date of the data to download, in YYYY-MM-DD format.}

\item{date}{a character string indicating the specific date of the data to download, in YYYY-MM-DD format.}

\item{verbose}{a logical indicating whether to print the response details or not.}

\item{field}{a character string indicating the GigaPack field}

\item{type}{a character string indicating the GigaPack field candles or tech}

\item{fake}{a bool string indicating the Giga Candles or Alter Giga}

\item{reps}{number of alternative history geneartion}

\item{trim}{number of entropy in data}

\item{auto.assign}{a logical indicating whether to automatically assign the downloaded data to the global environment.}

\item{...}{additional arguments passed to getSymbols.AlgoPack}
}
\value{
returns an data.table object containing financial data
}
\description{
Download historical market data from GigaPack  for a given symbol and time range.
}
\note{
Not for the faint of heart. All profits and losses related are yours and yours alone. If you don't like it, write it yourself.
}
\examples{
getSymbols.Gigapack('SBER', field = 'disb.q20')
}
\author{
Vyacheslav Arbuzov
}
