% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MB_Server.R
\name{MB_init_state}
\alias{MB_init_state}
\title{Initialize MB Module State}
\usage{
MB_init_state(FM_yaml_file, MOD_yaml_file, id, session)
}
\arguments{
\item{FM_yaml_file}{App configuration file with FM as main section.}

\item{MOD_yaml_file}{Module configuration file with MC as main section.}

\item{id}{ID string for the module.}

\item{session}{Shiny session variable}
}
\value{
list containing an empty MB state
}
\description{
Creates a list of the initialized module state
}
\examples{
# Within shiny both session and input variables will exist,
# this creates examples here for testing purposes:
sess_res = MB_test_mksession()
session = sess_res$session
input   = sess_res$input

state = MB_init_state(
   FM_yaml_file  = system.file(package = "formods",
                               "templates",
                               "formods.yaml"),
   MOD_yaml_file = system.file(package = "ruminate",
                               "templates",
                               "MB.yaml"),
   id              = "MB",
   session         = session)

state
}
