% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/midas_functions.R
\name{MEM_MIDAS_pred_no_skew}
\alias{MEM_MIDAS_pred_no_skew}
\title{MEM-MIDAS one-step-ahead predictions (no skewness parameter)}
\usage{
MEM_MIDAS_pred_no_skew(param, x, mv_m, K)
}
\arguments{
\item{param}{Vector of starting values. It must be a five--dimensional vector. See the example below.}

\item{x}{Dependent variable, usually the realized volatility. It must be positive and "xts" object.}

\item{mv_m}{MIDAS variable already transformed into a matrix, through \code{\link{mv_into_mat}} function.}

\item{K}{Number of (lagged) realizations of the MIDAS variable to consider.}
}
\value{
The resulting vector is the one-step-ahead prediction for each \eqn{i,t}.
}
\description{
Predicts the dependent variable, usually the realized volatility, for the MEM-MIDAS.
For details, see \insertCite{amendola2020doubly;textual}{rumidas} and \insertCite{engle_gallo_2006;textual}{rumidas}.
}
\examples{
# est_val<-c(alpha=0.10,beta=0.8,m=0,theta=-0.16,w2=5)
# real<-(rv5['/2010'])^0.5		# realized volatility
# mv_m<-mv_into_mat(real,diff(indpro),K=12,"monthly")
# sum(MEM_MIDAS_pred_no_skew(est_val,real,mv_m,K=12))
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{mv_into_mat}}.
}
\keyword{internal}
