% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_conversion.R
\name{allelic_list}
\alias{allelic_list}
\title{Create genotype lists for each locus}
\usage{
allelic_list(cs, ac, samp_type = "both")
}
\arguments{
\item{cs}{a clean short genetic data matrix; the second element of the
output from \code{tcf2long}. Must have a column of individual identifiers, named "indiv"}

\item{ac}{allele counts from a_freq_list}

\item{samp_type}{choose which sample types of individuals to include in output:
"mixture", "both", or "reference"}
}
\value{
\code{allelic_list} returns a two-component nested list, with data stored as character
names of alleles ($chr) or as integer indices for the alleles ($int). Both forms contain lists
representing to loci, with two component vectors corresponding to gene copies a and b.
}
\description{
Uses the allele counts from \code{a_freq_list} and the cleaned short-format output of
\code{tcf2long} to generate a nested list of individual genotypes for each locus
}
\examples{
example(a_freq_list)
ale_cs <- ale_long$clean_short
# Get the vectors of gene copies a and b for all loci in integer index form
ale_alle_list <- allelic_list(ale_cs, ale_ac)$int

}
\keyword{internal}
