% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_col.R
\name{rtry_select_col}
\alias{rtry_select_col}
\title{Select columns}
\usage{
rtry_select_col(input, ..., showOverview = TRUE)
}
\arguments{
\item{input}{Input data frame or data table.}

\item{\dots}{Column names to be selected.}

\item{showOverview}{Default \code{TRUE} displays the dimension and column names of the selected columns.}
}
\value{
An object of the same type as the input data.
}
\description{
This function selects the specified columns from the input data.
}
\examples{
# Select certain columns from the provided sample data (data_TRY_15160)
data_selected <- rtry_select_col(data_TRY_15160,
                   ObsDataID, ObservationID, AccSpeciesID, AccSpeciesName,
                   ValueKindName, TraitID, TraitName, DataID, DataName, OriglName,
                   OrigValueStr, OrigUnitStr, StdValue, UnitName, OrigObsDataID,
                   ErrorRisk, Comment)

# Expected message:
# dim:   1782 17
# col:   ObsDataID ObservationID AccSpeciesID AccSpeciesName ValueKindName TraitID
#        TraitName DataID DataName OriglName OrigValueStr OrigUnitStr StdValue
#        UnitName OrigObsDataID ErrorRisk Comment
}
\references{
This function makes use of the \code{\link[dplyr]{select}} function
within the \code{dplyr} package.
}
\seealso{
\code{\link{rtry_remove_col}}
}
