% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_gof.R
\name{gof}
\alias{gof}
\alias{gof.trim}
\title{Extract TRIM goodness-of-fit information.}
\usage{
gof(x)

\method{gof}{trim}(x)
}
\arguments{
\item{x}{an object of class \code{\link{trim}} (as returned by \code{\link{trim}})}
}
\value{
a list of type "trim.gof", containing elements \code{chi2}, \code{LR}
and \code{AIC}, for Chi-squared, Likelihoof Ratio and Akaike informatiuon content,
respectively.
}
\description{
\code{\link{trim}} computes three goodness-of-fit measures:
\itemize{
  \item Chi-squared
  \item Likelihood ratio
  \item Akaike Information content
}
}
\examples{
data(skylark)
z <- trim(count ~ site + time, data=skylark, model=2)
# prettyprint GOF information
gof(z)

# get individual elements, e.g. p-value
L <- gof(z)
LR_p <- L$LR$p # get p-value for likelihood ratio

}
\seealso{
Other analyses: \code{\link{coef.trim}},
  \code{\link{index}}, \code{\link{now_what}},
  \code{\link{overall}}, \code{\link{overdispersion}},
  \code{\link{plot.trim.index}},
  \code{\link{plot.trim.overall}}, \code{\link{results}},
  \code{\link{serial_correlation}},
  \code{\link{summary.trim}}, \code{\link{totals}},
  \code{\link{trim}}, \code{\link{vcov.trim}},
  \code{\link{wald}}
}

