% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmpg.R
\name{rmpg}
\alias{rmpg}
\title{Relative median at-risk-of-poverty gap}
\usage{
rmpg(dataset, arpt.value, ci = FALSE, rep = 1000, verbose = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables obtained by using the setupDataset function.}

\item{arpt.value}{the at-risk-of-poverty threshold to be used  (see arpt).}

\item{ci}{logical; if  TRUE, 95 percent confidence interval is given for the relative median at-risk-of-poverty gap.}

\item{rep}{a number to do the confidence interval using boostrap technique.}

\item{verbose}{logical; if TRUE the confindence interval is plotted.}
}
\value{
The value of the relative median at-risk-of-poverty gap.
}
\description{
Estimates the relative median at-risk-of-poverty gap which is the difference between the at-risk-of-poverty threshold and the median equivalized disposable income of people below the at-risk-of-poverty threshold, expressed as a percentage of this threshold.
}
\details{
The equivalized disposable income is calculated using the standar equivalence scale (called the modified OECD scale) recommended by Eurostat. The parametric scale of Buhmann et al. (1988) can also be used. The default is the modified OECD scale  (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT", s = "OECD")
rmpg(ATdataset,arpt.value = arpt(ATdataset))

}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

\url{http://ec.europa.eu/eurostat/statistics-explained/index.php/Glossary:Relative_median_at-risk-of-poverty_gap}
}
\seealso{
arpt, setupDataset
}

