% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arpt.R
\name{arpt}
\alias{arpt}
\title{At-risk-of-poverty threshold}
\usage{
arpt(dataset, pz = 0.6, ci = FALSE, rep = 500, verbose = FALSE)
}
\arguments{
\item{dataset}{a data.frame containing variables obtained by using the setupDataset function.}

\item{pz}{a number between 0 and 1 which represents the percentage to be used to calculate the at-risk-of-poverty threshold. The default is 0.6.}

\item{ci}{logical; if  TRUE, 95 percent confidence interval is given for the at-risk-of-poverty threshold.}

\item{rep}{a number to do the confidence interval using boostrap technique.}

\item{verbose}{logical; if TRUE the confindence interval is plotted.}
}
\value{
The value of the at-risk-of-poverty threshold.
}
\description{
Estimates the at-risk-of-poverty threshold which is set at 60 percent of the median equivalized disposable income using the standard definition.
}
\details{
The equivalized disposable income is calculated using the standar equivalence scale (called the modified OECD scale) recommended by Eurostat. The parametric scale of Buhmann et al.(1988) can also be used. The default is the modified OECD scale  (see setupDataset).
}
\examples{
data(eusilc2)
ATdataset <- setupDataset(eusilc2, country = "AT", s = "OECD")
arpt(ATdataset)
}
\author{
A. Berihuete, C.D. Ramos and M.A. Sordo
}
\references{
B. Buhmann et al. (1988) Equivalence scales, well-being, inequality and poverty: sensitivity estimates across ten countries using the Luxembourg Income Study (LIS) database, Review of Income and Wealth, 34, 115--142.

\url{http://ec.europa.eu/eurostat/statistics-explained/index.php/Glossary:At-risk-of-poverty_rate}
}
\seealso{
setupDataset
}

