% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_measures.R
\name{clean_measures}
\alias{clean_measures}
\title{Outputs clean rh_corrected_nephelometer measures for analysis.}
\usage{
clean_measures(micropem_object, hepa_start = FALSE, hepa_end = FALSE)
}
\arguments{
\item{micropem_object}{the MicroPEM object}

\item{hepa_start}{Boolean indicating whether there were measurements with HEPA filters at the beginning.}

\item{hepa_end}{Boolean indicating whether there were measurements with HEPA filters at the end.}
}
\value{
A MicroPEM object.
}
\description{
Outputs clean rh_corrected_nephelometer measures for analysis.
}
\details{
rh_corrected_nephelometer values are set to NA if they are negative or
if the RH at the same time is higher than 90\%.
rh_corrected_nephelometer values are also corrected for the HEPA zeroings (start and end, if there were done):
if a stable period longer than 3 minutes can be identified for the HEPA period,
using the changepoint \code{\link[changepoint]{cpt.mean}} function, there is a zero value.
There can be no zero values, only one (beginning or end) or two.
If there is only one zero value, it is substracted from all rh_corrected_nephelometer values.
If there are two, a linear interpolation is done between the two values and the resulting vector
is substracted from the rh_corrected_nephelometer values.
}
\examples{
data(micropemChai)
cleanMP <- clean_measures(micropemChai)
cleanMP$summary()
}
