% Generated by roxygen2 (4.0.2): do not edit by hand
\name{LBA}
\alias{LBA}
\alias{dlba_frechet}
\alias{dlba_gamma}
\alias{dlba_lnorm}
\alias{dlba_norm}
\alias{plba_frechet}
\alias{plba_gamma}
\alias{plba_lnorm}
\alias{plba_norm}
\alias{rlba_frechet}
\alias{rlba_gamma}
\alias{rlba_lnorm}
\alias{rlba_norm}
\title{The linear Ballistic Accumulator (LBA)}
\usage{
dlba_norm(t, A, b, t0, mean_v, sd_v, posdrift = TRUE, robust = FALSE)

plba_norm(t, A, b, t0, mean_v, sd_v, posdrift = TRUE, robust = FALSE)

rlba_norm(n, A, b, t0, mean_v, sd_v, st0 = 0, posdrift = TRUE)

dlba_gamma(t, A, b, t0, shape_v, rate_v, scale_v)

plba_gamma(t, A, b, t0, shape_v, rate_v, scale_v)

rlba_gamma(n, A, b, t0, shape_v, rate_v, scale_v, st0 = 0)

dlba_frechet(t, A, b, t0, shape_v, scale_v)

plba_frechet(t, A, b, t0, shape_v, scale_v)

rlba_frechet(n, A, b, t0, shape_v, scale_v, st0 = 0)

dlba_lnorm(t, A, b, t0, meanlog_v, sdlog_v, robust = FALSE)

plba_lnorm(t, A, b, t0, meanlog_v, sdlog_v, robust = FALSE)

rlba_lnorm(n, A, b, t0, meanlog_v, sdlog_v, st0 = 0)
}
\arguments{
\item{t}{a vector of RTs.}

\item{A}{start point interval or evidence in accumulator before beginning of decision process. Start point varies from trial to trial in the interval [0, \code{A}] (uniform distribution). Average amount of evidence before evidence accumulation across trials is \code{A}/2.}

\item{b}{response threshold. (\code{b} - \code{A}/2) is a measure of "response caution".}

\item{t0}{non-decision time or response time constant (in seconds). Average duration of all non-decisional processes (encoding and response execution).}

\item{mean_v,sd_v}{mean and standard deviation of normal distribution for drift rate (\code{norm}). See \code{\link{Normal}}}

\item{posdrift}{logical. Should driftrates be forced to be positive? Default is \code{TRUE}. (Uses truncated normal for random generation).}

\item{robust}{logical. Should robust normal distributions be used for \code{norm} and \code{lnorm}? Can be helpful in rare cases but is approximately three times slower than the non-robust versions. Default is \code{FALSE}.}

\item{n}{desired number of observations (scalar integer).}

\item{st0}{variability of non-decision time. Uniformly distributed around \code{t0} + \code{st0} (i.e., \code{t0} is the lower bound). Only available in random number generation functions \code{rlba_}.}

\item{shape_v,rate_v,scale_v}{shape, rate, and scale of gamma (\code{gamma}) and scale and shape of Frechet (\code{frechet}) distributions for drift rate. See \code{\link{GammaDist}} or \code{\link[evd]{frechet}}. For Gamma, scale = 1/shape and shape = 1/scale.}

\item{meanlog_v,sdlog_v}{mean and standard deviation of lognormal distribution on the log scale for drift rate (\code{lnorm}). See \code{\link{Lognormal}}.}
}
\value{
All functions starting with a \code{d} return the density (PDF), all functions starting with \code{p} return the distribution function (CDF), and all functions starting with \code{r} return random response times and responses (in a \code{data.frame}).
}
\description{
Density, distribution function, and random generation for the LBA model with the following parameters: \code{A} (upper value of starting point), \code{b} (response threshold), \code{t0} (non-decision time), and driftrate (\code{v}). All functions are available with different distributions underlying the drift rate: Normal (\code{norm}), Gamma (\code{gamma}), Frechet (\code{frechet}), and log normal (\code{lnorm}).
}
\details{
For random number generation at least one of the distribution parameters (i.e., \code{mean_v}, \code{sd_v}, \code{shape_v}, \code{scale_v}, \code{rate_v}, \code{meanlog_v}, and \code{sdlog_v}) should be of length > 1 to receive RTs from multiple responses. Shorter vectors are recycled as necessary.\cr
Note that for random number generation from a normal distribution for the driftrate the number of returned samples may be less than the number of requested samples if \code{posdrifts==FALSE}.
}
\note{
Density (i.e., \code{dlba_}) and distribution (i.e., \code{plba_}) functions are vectorized for all parameters (i.e., in case parameters are not of the same length as \code{t}, parameters are recycled). Somewhat inconsistently, the random number generation functions \code{rlba_} accept only scalar inputs.
}
\examples{

## random number generation using different distributions for v:
rlba_norm(10, A=0.5, b=1, t0 = 0.5, mean_v=c(1.2, 1), sd_v=c(0.2,0.3))
rlba_gamma(10, A=0.5, b=1, t0 = 0.5, shape_v=c(1.2, 1), scale_v=c(0.2,0.3))
rlba_frechet(10, A=0.5, b=1, t0 = 0.5, shape_v=c(1.2, 1), scale_v=c(0.2,0.3))
rlba_lnorm(10, A=0.5, b=1, t0 = 0.5, meanlog_v=c(1.2, 1), sdlog_v=c(0.2, 0.3))

# use somewhat plausible values for plotting:
A <- 0.2
b <- 0.5
t0 <- 0.3

# plot density:
curve(dlba_norm(x, A=A, b=b, t0=t0, mean_v = 1.0, sd_v = 0.5), ylim = c(0, 4),
      xlim=c(0,3), main="Density/PDF of LBA versions", ylab="density", xlab="response time")
curve(dlba_gamma(x, A=A, b=b, t0=t0, shape_v=1, scale_v=1), add=TRUE, lty = 2)
curve(dlba_frechet(x, A=A, b=b, t0=t0, shape_v=1,scale_v=1.0), add=TRUE, lty = 3)
curve(dlba_lnorm(x, A=A, b=b, t0=t0, meanlog_v = 0.5, sdlog_v = 0.5), add=TRUE, lty = 4)
legend("topright", legend=c("Normal", "Gamma", "Frechet", "Log-Normal"), 
      title = expression("Distribution of"~~italic(v)), lty = 1:4)


# plot cdf:
curve(plba_norm(x, A=A, b=b, t0=t0, mean_v=1.0, sd_v=1.0), 
      xlim = c(0, 3),ylim = c(0,1), 
      ylab = "cumulative probability", xlab = "response time",
      main = "Distribution/CDF of LBA versions")
curve(plba_gamma(x, A=A, b=b, t0=t0, shape_v=1,scale_v=1), add=TRUE, lty = 2)
curve(plba_frechet(x, A=A, b=b, t0=t0, shape=1, scale=1), add=TRUE, lty = 3)
curve(plba_lnorm(x, A=A, b=b, t0=t0, meanlog_v=0.5, sdlog_v = 0.5), add=TRUE, lty = 4)
legend("bottomright", legend=c("Normal", "Gamma", "Frechet", "Log-Normal"), 
       title = expression("Distribution of"~~italic(v)), lty = 1:4)
}
\references{
Brown, S. D., & Heathcote, A. (2008). The simplest complete model of choice response time: Linear ballistic accumulation. \emph{Cognitive Psychology}, 57(3), 153-178. doi:10.1016/j.cogpsych.2007.12.002

Donkin, C., Averell, L., Brown, S., & Heathcote, A. (2009). Getting more from accuracy and response time data: Methods for fitting the linear ballistic accumulator. \emph{Behavior Research Methods}, 41(4), 1095-1110. doi:10.3758/BRM.41.4.1095

Heathcote, A., & Love, J. (2012). Linear deterministic accumulator models of simple choice. \emph{Frontiers in Psychology}, 3, 292. doi:10.3389/fpsyg.2012.00292
}

