% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00tabletrees.R
\docType{class}
\name{ElementaryTable-class}
\alias{ElementaryTable-class}
\alias{ElementaryTable}
\alias{TableTree-class}
\alias{TableTree}
\title{\code{TableTree} classes}
\usage{
ElementaryTable(
  kids = list(),
  name = "",
  lev = 1L,
  label = "",
  labelrow = LabelRow(lev = lev, label = label, vis = !isTRUE(iscontent) && !is.na(label)
    && nzchar(label)),
  rspans = data.frame(),
  cinfo = NULL,
  iscontent = NA,
  var = NA_character_,
  format = NULL,
  na_str = NA_character_,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  header_section_div = NA_character_,
  hsep = default_hsep(),
  trailing_section_div = NA_character_,
  inset = 0L
)

TableTree(
  kids = list(),
  name = if (!is.na(var)) var else "",
  cont = EmptyElTable,
  lev = 1L,
  label = name,
  labelrow = LabelRow(lev = lev, label = label, vis = nrow(cont) == 0 && !is.na(label) &&
    nzchar(label)),
  rspans = data.frame(),
  iscontent = NA,
  var = NA_character_,
  cinfo = NULL,
  format = NULL,
  na_str = NA_character_,
  indent_mod = 0L,
  title = "",
  subtitles = character(),
  main_footer = character(),
  prov_footer = character(),
  page_title = NA_character_,
  hsep = default_hsep(),
  header_section_div = NA_character_,
  trailing_section_div = NA_character_,
  inset = 0L
)
}
\arguments{
\item{kids}{(\code{list})\cr list of direct children.}

\item{name}{(\code{string})\cr name of the split/table/row being created. Defaults to the value of the
corresponding label, but is not required to be.}

\item{lev}{(\code{integer(1)})\cr nesting level (roughly, indentation level in practical terms).}

\item{label}{(\code{string})\cr a label (not to be confused with the name) for the object/structure.}

\item{labelrow}{(\code{LabelRow})\cr the \code{LabelRow} object to assign to the table. Constructed from \code{label} by default
if not specified.}

\item{rspans}{(\code{data.frame})\cr currently stored but otherwise ignored.}

\item{cinfo}{(\code{InstantiatedColumnInfo} or \code{NULL})\cr column structure for the object being created.}

\item{iscontent}{(\code{flag})\cr whether the \code{TableTree}/\code{ElementaryTable} is being constructed as the content
table for another \code{TableTree}.}

\item{var}{(\code{string})\cr variable name.}

\item{format}{(\code{string}, \code{function}, or \code{list})\cr format associated with this split. Formats can be declared via
strings (\code{"xx.x"}) or function. In cases such as \code{analyze} calls, they can be character vectors or lists of
functions. See \code{\link[formatters:list_formats]{formatters::list_valid_format_labels()}} for a list of all available format strings.}

\item{na_str}{(\code{string})\cr string that should be displayed when the value of \code{x} is missing. Defaults to \code{"NA"}.}

\item{indent_mod}{(\code{numeric})\cr modifier for the default indent position for the structure created by this
function (subtable, content table, or row) \emph{and all of that structure's children}. Defaults to 0, which
corresponds to the unmodified default behavior.}

\item{title}{(\code{string})\cr single string to use as main title (\code{\link[formatters:title_footer]{formatters::main_title()}}). Ignored for subtables.}

\item{subtitles}{(\code{character})\cr a vector of strings to use as subtitles (\code{\link[formatters:title_footer]{formatters::subtitles()}}), where every
element is printed on a separate line. Ignored for subtables.}

\item{main_footer}{(\code{character})\cr a vector of strings to use as main global (non-referential) footer materials
(\code{\link[formatters:title_footer]{formatters::main_footer()}}), where every element is printed on a separate line.}

\item{prov_footer}{(\code{character})\cr a vector of strings to use as provenance-related global footer materials
(\code{\link[formatters:title_footer]{formatters::prov_footer()}}), where every element is printed on a separate line.}

\item{header_section_div}{(\code{string})\cr string which will be used to divide the header from the table. See
\code{\link[=header_section_div]{header_section_div()}} for the associated getter and setter. Please consider changing last element of
\code{\link[=section_div]{section_div()}} when concatenating tables that require a divider between them.}

\item{hsep}{(\code{string})\cr set of characters to be repeated as the separator between the header and body of
the table when rendered as text. Defaults to a connected horizontal line (unicode 2014) in locals that use a UTF
charset, and to \code{-} elsewhere (with a once per session warning). See \code{\link[formatters:default_horizontal_sep]{formatters::set_default_hsep()}} for further
information.}

\item{trailing_section_div}{(\code{string})\cr string which will be used as a section divider after the printing
of the last row contained in this (sub)table, unless that row is also the last table row to be printed overall,
or \code{NA_character_} for none (the default). When generated via layouting, this would correspond to the
\code{section_div} of the split under which this table represents a single facet.}

\item{inset}{(\code{numeric(1)})\cr number of spaces to inset the table header, table body, referential footnotes, and
main_footer, as compared to alignment of title, subtitle, and provenance footer. Defaults to 0 (no inset).}

\item{cont}{(\code{ElementaryTable})\cr content table.}

\item{page_title}{(\code{character})\cr page-specific title(s).}
}
\value{
A formal object representing a populated table.
}
\description{
\code{TableTree} classes

Table constructors and classes
}
\author{
Gabriel Becker
}
