% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tokenbrowser.r
\name{syntax_reader}
\alias{syntax_reader}
\title{Create a full text browser with highlighted rsyntax annotations}
\usage{
syntax_reader(
  tokens,
  annotation,
  value = NULL,
  value2 = NULL,
  meta = NULL,
  token_col = "token",
  filename = NULL,
  view = TRUE,
  random_seed = NA,
  ...
)
}
\arguments{
\item{tokens}{A tokenIndex}

\item{annotation}{The name of the column that contains the rsyntax annotation}

\item{value}{Optionally, a character vector with values in annotation. If used, only these values are fully colored, and the other (non NA) values only have border colors.}

\item{value2}{Optionally, a character vector with values in annotation other than those specified in 'value'. If used, only these values have border colors.}

\item{meta}{Optionally, a data.frame with document meta data. Has to have a column named doc_id of which the values match with the doc_id column in tokens}

\item{token_col}{The name of the column in tokens with the token text}

\item{filename}{Optionally, a filename to directly save the file. If not specified, a temporary file is created}

\item{view}{If TRUE, the browser will immediatly be viewed in the viewer panel}

\item{random_seed}{If a number is given, it is used as a seed to randomize the order of documents. This is usefull for
validations purposes, because the doc_id in the tokenindex is sorted.}

\item{...}{Arguments passed to \link[tokenbrowser]{create_browser}}
}
\value{
The url for the file
}
\description{
Create a full text browser with highlighted rsyntax annotations
}
\examples{
tokens = tokens_spacy

## two simple example tqueries
passive = tquery(pos = "VERB*", label = "predicate",
                children(relation = c("agent"), label = "subject"))
active =  tquery(pos = "VERB*", label = "predicate",
                children(relation = c("nsubj", "nsubjpass"), label = "subject"))


\donttest{
tokens = annotate_tqueries(tokens, 'clause', pas=passive, act=active)
syntax_reader(tokens, annotation = 'clause', value = 'subject')
}
}
