% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/os_billlookup.R
\name{os_billlookup}
\alias{os_billlookup}
\title{Lookup bills on OpenStates.}
\usage{
os_billlookup(state = NULL, session = NULL, bill_id = NULL,
  fields = NULL, per_page = NULL, page = NULL, as = "table",
  key = NULL, ...)
}
\arguments{
\item{state}{state two-letter abbreviation (character), required}

\item{session}{session of congress (integer), e.g., 2009-2010 = 20092010,
required}

\item{bill_id}{One or more identification numbers of bills (character), required}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{as}{(character) One of table (default), list, or response
(crul response object)}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
List of output fields.
}
\description{
Lookup bills on OpenStates.
}
\examples{
\dontrun{
os_billlookup(state='ca', session=20092010, bill_id='AB 667')
os_billlookup(state='ca', session=20092010, bill_id='AB 667', per_page=1)
os_billlookup(state='ca', session=20092010, bill_id='AB 667', per_page=1, fields='id')
os_billlookup(state='ca', session=20092010, bill_id='AB 667',
   per_page=3, fields=c('id','title'))
os_billlookup(state='ca', session=20092010, bill_id='SB 425')
os_billlookup(state='ca', session=20092010, bill_id=c('AB 667','SB 425'))
os_billlookup(state='ca', session=20092010, bill_id='AB 667', verbose = TRUE)
}
}
