% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ie_individuals}
\alias{ie_individuals}
\title{Politician aggregrates: Search for contributions to politicians.}
\usage{
ie_individuals(method = NULL, entity_id = NULL, cycle = NULL,
  limit = NULL, page = NULL, per_page = NULL, return = "table",
  key = getOption("SunlightLabsKey",
  stop("need an API key for Sunlight Labs")), ...)
}
\arguments{
\item{method}{(character) The query string. One of top_ind, top_recorg, top_recpol,
party_breakdown, lobb_reg, lobb_cli, or lobb_iss.}

\item{entity_id}{(character) The transparencydata ID to look up.}

\item{cycle}{(character) Filter results to a particular type of entity. One of politician,
organization, individual or industry.}

\item{limit}{(integer) Limit number of records returned.}

\item{page}{The page of results to return; defaults to 1.}

\item{per_page}{The number of results to return per page, defaults to 1,000.
The maximum number of records per page is 100,000.}

\item{key}{your SunlightLabs API key; loads from .Rprofile}

\item{...}{Optional additional curl options (debugging tools mostly)}

\item{return}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}
}
\value{
A list. Depends on parameters used. Ranges from a single ID returned to basic
   information about the the contributions to and from each entity.
}
\description{
Politician aggregrates: Search for contributions to politicians.
}
\examples{
\dontrun{
# Top individuals
ie_individuals(method='top_ind', limit=1)
ie_individuals(method='top_ind', limit=3)

# Top recipient organizations
ie_individuals(method='top_recorg', entity_id='a03df5d9b20e467fa0ceaefa94c4491e')
ie_individuals(method='top_recorg', entity_id='a03df5d9b20e467fa0ceaefa94c4491e',
   cycle=2012, limit=1)

# Top recipients politicians
ie_individuals(method='top_recpol', entity_id='a03df5d9b20e467fa0ceaefa94c4491e')
ie_individuals(method='top_recpol', entity_id='a03df5d9b20e467fa0ceaefa94c4491e',
   cycle=2012, limit=1)

# Party breakdown
ie_individuals(method='party_breakdown', entity_id='cc768536a9434b9da6fef5846a16ee88')

# Lobbying registrants
ie_individuals(method='lobb_reg', entity_id='4d052c80ef184ce5a5e41e6d34dc452f')

# Lobbying clients
ie_individuals(method='lobb_cli', entity_id='4d052c80ef184ce5a5e41e6d34dc452f', cycle=2002)

# Lobbying issues
ie_individuals(method='lobb_iss', entity_id='4d052c80ef184ce5a5e41e6d34dc452f', limit=2)
}
}

