/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis;

import java.util.Iterator;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.SGSets;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.target.BooleanTarget;

public class WeightedCoveringAnalyzer {
    private void resetWeights(DataView population) {
        Iterator<DataRecord> iter = population.instanceIterator();
        while (iter.hasNext()) {
            DataRecord instance = iter.next();
            instance.setWeight(1.0);
        }
    }

    private SG getBestCoveringSubgroup(SGSet sgSet, IQualityFunction qf) {
        double bestQuality = Double.NEGATIVE_INFINITY;
        SG bestSG = null;
        for (SG sg : sgSet) {
            double q = qf.evaluate(sg);
            if (!(q > bestQuality)) continue;
            bestSG = sg;
            bestQuality = q;
        }
        return bestSG;
    }

    private void adjustPopulationWeights(SG sg, DataView population) {
        Iterator<DataRecord> instanceIterator = population.instanceIterator();
        while (instanceIterator.hasNext()) {
            DataRecord instance = instanceIterator.next();
            if (!sg.getSGDescription().isMatching(instance) || !((BooleanTarget)sg.getTarget()).isPositive(instance)) continue;
            instance.setWeight(1.0 / (1.0 + 1.0 / instance.getWeight()));
        }
    }

    public SGSet getKBestCoveringSubgroups(int k, SGSet sgSet, DataView population, IQualityFunction qf) {
        this.resetWeights(population);
        SGSet workingSet = SGSets.copySGSet(sgSet);
        SGSet result = SGSets.createSGSet();
        int i = 0;
        while (i < k) {
            SG sg = this.getBestCoveringSubgroup(workingSet, qf);
            if (sg == null) break;
            workingSet.remove(sg);
            result.add(sg);
            this.adjustPopulationWeights(sg, population);
            ++i;
        }
        this.resetWeights(population);
        return result;
    }
}

