/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.converters;

import au.com.bytecode.opencsv.CSVReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.vikamine.kernel.data.converters.GenericDataTable;

public class GenericDataTableReader {
    private GenericDataTableReader() {
    }

    public static int countCSVLines(File f, char separator, char quote) throws IOException {
        CSVReader csvr = new CSVReader(new BufferedReader(new FileReader(f)), separator, quote);
        int count = 0;
        String[] nextLine = csvr.readNext();
        while (nextLine != null) {
            ++count;
            nextLine = csvr.readNext();
        }
        csvr.close();
        return count;
    }

    public static GenericDataTable readTable(File f, char separator, char quote, boolean withHeader) throws IOException {
        CSVReader csvr = new CSVReader(new BufferedReader(new FileReader(f)), separator, quote);
        String[] nextLine = csvr.readNext();
        GenericDataTable table = new GenericDataTable(GenericDataTableReader.countCSVLines(f, separator, quote) - (withHeader ? 1 : 0), nextLine.length, withHeader);
        int lineNumber = 0;
        do {
            if (withHeader) {
                if (lineNumber == 0) {
                    table.setHeader(nextLine);
                } else {
                    table.setRow(lineNumber - 1, nextLine);
                }
            } else {
                table.setRow(lineNumber, nextLine);
            }
            ++lineNumber;
        } while ((nextLine = csvr.readNext()) != null);
        csvr.close();
        return table;
    }
}

