% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_data-methods.R
\name{extract_data.stansim_simulation}
\alias{extract_data.stansim_simulation}
\title{Extract data from a stansim_simulation object}
\usage{
\method{extract_data}{stansim_simulation}(object, datasets = "all",
  parameters = "all", estimates = "all", values = NULL,
  param_expand = TRUE, ...)
}
\arguments{
\item{object}{An object of S3 class stansim_simulation.}

\item{datasets}{Either a character vector containing the names of datasets
(as provided to the original \code{fit_models()} call) fitted, or the
string \code{"all"}. The former will only return values for the
corresponding datasets, the latter applies no filtering on datasets}

\item{parameters}{Either a character vector containing the names of stan
model parameters present in the fitted stan models, or the string
\code{"all"}. The former will only return values for the corresponding
parameters, the latter applies no filtering on parameters. See also the
effect of the \code{param_expand} argument.}

\item{estimates}{Either a character vector containing the names of parameter
estimates calculated (e.g. c("2.5%", "mean", "97.5%")), or the string
\code{"all"}. The former will only return values for the corresponding
estimates, the latter applies no filtering on estimates}

\item{values}{Either a function taking a single numeric argument that returns
a Boolean value, or \code{NULL}. The former will only return values for
which the provided function is \code{TRUE}, the latter applies no filtering
on values.}

\item{param_expand}{If \code{TRUE} then any provided \code{parameters}
arguments, without specified dimension, will be expanded to capture all
dimensions of that parameter. For example, \code{"eta"} becomes
\code{c("eta[1]", "eta[2]", "eta[3]", ...)}. Expansion isn't carried out if
a parameters dimension is specified (e.g. \code{parameters = "eta[1]"}) or
if \code{param_expand = FALSE}.}

\item{...}{other arguments not used by this method}
}
\value{
A dataframe containing the specified data.
}
\description{
Applied to an object of type stansim_simulation,
  \code{extract_data()} will return the object's simulation data as a
  dataframe, subject to the filtering specified by the function arguments.
}
\examples{
\dontrun{
# extract full dataset
extract_data(simulation)

# extract all parameter means, 2.5\% & 97.5\% percentiles
extract_data(simulation, estimates = c("2.5\%", "mean", "97.5\%"))

# extract all Rhat estimates greater than 1.1
extract_data(simulation, estimates = "Rhat",
             values = function(x) x > 1.1)

# extract all "eta" parameters
extract_data(simulation, parameters = "eta")

# extract all "eta[1]" parameters
extract_data(simulation, parameters = "eta[1]",
             param_expand = FALSE)

# extract all rows for dataset "data_file-12.rds"
extract_data(simulation, datasets = "data_file-12.rds")
}

}
