% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_linpred.R
\name{posterior_linpred.stanreg}
\alias{posterior_linpred.stanreg}
\alias{posterior_linpred}
\title{Posterior distribution of the linear predictor}
\usage{
\method{posterior_linpred}{stanreg}(object, transform = FALSE,
  newdata = NULL, draws = NULL, re.form = NULL, offset = NULL,
  XZ = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{transform}{Should the linear predictor be transformed using the
inverse-link function? The default is \code{FALSE}, in which case the
untransformed linear predictor is returned.}

\item{newdata, draws, re.form, offset}{Same as for \code{\link{posterior_predict}}.}

\item{XZ}{If \code{TRUE} then instead of computing the linear predictor the 
design matrix \code{X} (or \code{cbind(X,Z)} for models with group-specific
terms) constructed from \code{newdata} is returned. The default is 
\code{FALSE}.}

\item{...}{Currently ignored.}
}
\value{
The default is to return a \code{draws} by \code{nrow(newdata)}
  matrix of simulations from the posterior distribution of the (possibly
  transformed) linear predictor. The exception is if the argument \code{XZ}
  is set to \code{TRUE} (see the \code{XZ} argument description above).
}
\description{
Extract the posterior draws of the linear predictor, possibly transformed by 
the inverse-link function. This function is occasionally useful, but it 
should be used sparingly. Inference and model checking should generally be 
carried out using the posterior predictive distribution (i.e., using 
\code{\link{posterior_predict}}).
}
\note{
For models estimated with \code{\link{stan_clogit}}, the number of 
  successes per stratum is ostensibly fixed by the research design. Thus,
  when calling \code{posterior_linpred} with new data and \code{transform =
  TRUE}, the \code{data.frame} passed to the \code{newdata} argument must
  contain an outcome variable and a stratifying factor, both with the same
  name as in the original \code{data.frame}. Then, the probabilities will
  condition on this outcome in the new data.
}
\examples{
if (!exists("example_model")) example(example_model)
print(family(example_model))

# linear predictor on log-odds scale
linpred <- posterior_linpred(example_model)
colMeans(linpred)

# probabilities
probs <- posterior_linpred(example_model, transform = TRUE)
colMeans(probs)

# not conditioning on any group-level parameters
probs2 <- posterior_linpred(example_model, transform = TRUE, re.form = NA)
apply(probs2, 2, median)

}
\seealso{
\code{\link{posterior_predict}} to draw from the posterior 
  predictive distribution of the outcome, which is typically preferable.
}
