% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinystan.R
\name{launch_shinystan.stanreg}
\alias{launch_shinystan.stanreg}
\alias{launch_shinystan}
\title{Using the ShinyStan GUI with rstanarm models}
\usage{
\method{launch_shinystan}{stanreg}(object, ppd = TRUE, seed = 1234,
  model_name = NULL, note = NULL,
  rstudio = getOption("shinystan.rstudio"), ...)
}
\arguments{
\item{object}{A fitted model object returned by one of the 
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{ppd}{Should \pkg{rstanarm} draw from the posterior predictive 
distribution before launching ShinyStan? The default is \code{TRUE}, 
although for very large objects it can be convenient to set it to 
\code{FALSE} as drawing from the posterior predictive distribution can be 
time consuming. If \code{ppd} is \code{TRUE} then graphical posterior 
predictive checks are available when ShinyStan is launched.}

\item{seed}{Passed to \code{\link[rstanarm]{pp_check}} (\pkg{rstanarm}) if 
\code{ppd} is \code{TRUE}.}

\item{model_name, note}{Optional arguments passed to
\code{\link[shinystan]{as.shinystan}}.}

\item{rstudio}{Only relevant for 'RStudio' users. The default (\code{FALSE})
is to launch the app in the user's default web browser rather than the 
pop-up Viewer provided by 'RStudio'. Users can change the default to
\code{TRUE} by setting the global option \code{options(shinystan.rstudio =
TRUE)}.}

\item{...}{Optional arguments passed to \code{\link[shiny]{runApp}}.}
}
\description{
The ShinyStan interface provides visual and numerical summaries of model
parameters and convergence diagnostics.
}
\details{
The \code{\link[shinystan]{launch_shinystan}} function will accept a
  \code{\link[=stanreg-objects]{stanreg}} object as input. Currently, almost 
  any model fit using one of \pkg{rstanarm}'s model-fitting functions can be 
  used with ShinyStan. The only exception is that ShinyStan does not 
  currently support \pkg{rstanarm} models fit using 
  \code{algorithm='optimizing'}. See the 
  \pkg{\link[=shinystan-package]{shinystan}} package documentation for more 
  information.
}
\section{Faster launch times}{

For some \pkg{rstanarm} models ShinyStan may take a very long time to launch.
If this is the case with one of your models you may be able to speed up
\code{launch_shinystan} in one of several ways:
\describe{
  \item{Prevent ShinyStan from preparing graphical posterior predictive
  checks:}{
  When used with a \code{\link[=stanreg-objects]{stanreg}} object 
  (\pkg{rstanarm} model object) ShinyStan will draw from the posterior 
  predictive distribution and prepare graphical posterior predictive checks 
  before launching. That way when you go to the PPcheck page the plots are 
  immediately available. This can be time consuming for models fit to very
  large datasets and you can prevent this behavior by creating a shinystan
  object before calling \code{launch_shinystan}. To do this use 
  \code{\link[shinystan]{as.shinystan}} with optional argument \code{ppd} set
  to \code{FALSE} (see the Examples section below). When you then launch
  ShinyStan and go to the PPcheck page the plots will no longer be 
  automatically generated and you will be presented with the standard
  interface requiring you to first specify the appropriate \eqn{y} and
  \eqn{yrep}, which can be done for many but not all \pkg{rstanarm} models.
  }
  \item{Use a shinystan object:}{
  Even if you don't want to prevent ShinyStan from preparing graphical
  posterior predictive checks, first creating a shinystan object using
  \code{\link[shinystan]{as.shinystan}} can reduce \emph{future} launch
  times. That is, \code{launch_shinystan(sso)} will be faster than
  \code{launch_shinystan(fit)}, where \code{sso} is a shinystan object and
  \code{fit} is a stanreg object. It still may take some time for 
  \code{as.shinystan} to create \code{sso} initially, but each time you
  subsequently call \code{launch_shinystan(sso)} it will reuse \code{sso}
  instead of internally creating a shinystan object every time. See the
  Examples section below.}
}
}

\examples{
\dontrun{
if (!exists("example_model")) example(example_model) 

# Launch the ShinyStan app without saving the resulting shinystan object
if (interactive()) launch_shinystan(example_model)

# Launch the ShinyStan app (saving resulting shinystan object as sso)
if (interactive()) sso <- launch_shinystan(example_model)

# First create shinystan object then call launch_shinystan
sso <- shinystan::as.shinystan(example_model)
if (interactive()) launch_shinystan(sso)

# Prevent ShinyStan from preparing graphical posterior predictive checks that
# can be time consuming. example_model is small enough that it won't matter
# much here but in general this can help speed up launch_shinystan
sso <- shinystan::as.shinystan(example_model, ppd = FALSE)
if (interactive()) launch_shinystan(sso)
}

}
\references{
Gabry, J., Simpson, D., Vehtari, A., Betancourt, M., and Gelman,
  A. (2018). Visualization in Bayesian workflow. \emph{Journal of the Royal
  Statistical Society Series A}, accepted for publication. arXiv preprint:
  \url{http://arxiv.org/abs/1709.01449}.

Muth, C., Oravecz, Z., and Gabry, J. (2018)
User-friendly Bayesian regression modeling: A tutorial with rstanarm and shinystan.
\emph{The Quantitative Methods for Psychology}. 14(2), 99--119.
\url{https://www.tqmp.org/RegularArticles/vol14-2/p099/p099.pdf}
}
