% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_ScaleNormalize.R
\name{ScaleNormalize}
\alias{ScaleNormalize}
\title{Re-scales input matrix proportinally to item popularity}
\description{
scales input user-item interaction matrix as per eq (16) from the paper.
Usage of such rescaled matrix with [PureSVD] model will be equal to running PureSVD
on the scaled cosine-based inter-item similarity matrix.
}
\references{
See \href{https://arxiv.org/pdf/1511.06033.pdf}{EigenRec: Generalizing PureSVD for
Effective and Efficient Top-N Recommendations} for details.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{norm}}{which norm model should make equal to one}

\item{\code{scale}}{how to rescale norm vector}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ScaleNormalize$new()}}
\item \href{#method-fit}{\code{ScaleNormalize$fit()}}
\item \href{#method-transform}{\code{ScaleNormalize$transform()}}
\item \href{#method-fit_transform}{\code{ScaleNormalize$fit_transform()}}
\item \href{#method-clone}{\code{ScaleNormalize$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
creates model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScaleNormalize$new(scale = 0.5, norm = 2, target = c("rows", "columns"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{numeric, how to rescale norm vector}

\item{\code{norm}}{numeric, which norm model should make equal to one}

\item{\code{target}}{character, defines whether rows or columns should be rescaled}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
fits the modes
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScaleNormalize$fit(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transform"></a>}}
\if{latex}{\out{\hypertarget{method-transform}{}}}
\subsection{Method \code{transform()}}{
transforms new matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScaleNormalize$transform(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit_transform"></a>}}
\if{latex}{\out{\hypertarget{method-fit_transform}{}}}
\subsection{Method \code{fit_transform()}}{
fits the model and transforms input
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScaleNormalize$fit_transform(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{input sparse matrix}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ScaleNormalize$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
