% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fields.R
\name{document_get_fields}
\alias{document_get_fields}
\title{Get the fields of a structured document as a tibble}
\usage{
document_get_fields(doc_id, api_key = get_api_key())
}
\arguments{
\item{doc_id}{Unique identifier of the document}

\item{api_key}{RSpace API key}
}
\value{
A tibble with the fields as rows.
}
\description{
This function retrieves the fields of a structured document and returns them
as a tibble, one row per field. As fields can contain HTML, the tibble can be
displayed prettier with, for example, the \code{gt} package (see the Examples).
}
\examples{
\dontrun{
library(gt)
document_get_fields("SD123456") |> gt() |> fmt_markdown(columns = c(content))
}
}
