% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost_rmse_biomee.R
\name{cost_rmse_biomee}
\alias{cost_rmse_biomee}
\title{RMSE cost function for BiomeE}
\usage{
cost_rmse_biomee(par, obs, drivers)
}
\arguments{
\item{par}{A vector containing parameter values for \code{'phiRL',
'LAI_light', 'tf_base', 'par_mort'} in that order.}

\item{obs}{A nested data frame of observations, following the structure of \code{biomee_validation_2},
for example.}

\item{drivers}{A nested data frame of driver data, for example \code{biomee_gs_leuning_drivers}.}
}
\value{
The root mean squared error (RMSE) between the observed and simulated
values of \code{'GPP','LAI','Density'} and \code{'Biomass'} (all variables
have the same weight). Relative errors (difference divided by observed values) are used
instead of absolute errors.
The cost function performs a BiomeE model run for parameter values
\code{par} and model drivers \code{drivers} given as arguments, producing the
simulated values used to compute the RMSE.
}
\description{
Cost function for parameter calibration, which computes the root mean squared
error (RMSE) between BiomeE simulations (using the input set of parameters)
and observed target variables.
Cost function for parameter calibration, which
computes the RMSE for the biomee model fitting target variables 
\code{'GPP','LAI','Density'} and \code{'Biomass'} for a given set of parameters.
}
\examples{
\donttest{
# Compute RMSE for a set of
# model parameter values
# and example data
cost_rmse_biomee(
 par = c(3.5, 3.5, 1, 1),
 obs = biomee_validation_2,
 drivers = biomee_gs_leuning_drivers
)
}
}
