% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_slurm_out.R
\name{get_slurm_out}
\alias{get_slurm_out}
\title{Reads the output of a function calculated on the Slurm cluster}
\usage{
get_slurm_out(slr_job, outtype = "raw", wait = TRUE)
}
\arguments{
\item{slr_job}{A \code{slurm_job} object.}

\item{outtype}{Can be "table" or "raw", see "Value" below for details.}

\item{wait}{Specify whether to block until \code{slr_job} completes.}
}
\value{
If \code{outtype = "table"}: A data frame with one column by 
  return value of the function passed to \code{slurm_apply}, where 
  each row is the output of the corresponding row in the params data frame 
  passed to \code{slurm_apply}.
  
  If \code{outtype = "raw"}: A list where each element is the output 
  of the function passed to \code{slurm_apply} for the corresponding
  row in the params data frame passed to \code{slurm_apply}.
}
\description{
This function reads all function output files (one by cluster node used) from 
the specified Slurm job and returns the result in a single data frame
(if "table" format selected) or list (if "raw" format selected). It doesn't 
record any messages (including warnings or errors) output to the R console
during the computation; these can be consulted by invoking 
\code{\link{print_job_status}}.
}
\details{
The \code{outtype} option is only relevant for jobs submitted with 
\code{slurm_apply}. Jobs sent with \code{slurm_call} only return a single
object, and setting \code{outtype = "table"} creates an error in that case.
}
\seealso{
\code{\link{slurm_apply}}, \code{\link{slurm_call}}
}
