% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{sc_filter}
\alias{sc_filter}
\title{Filter scorecard data by variable values.}
\usage{
sc_filter(sccall, ...)
}
\arguments{
\item{sccall}{Current list of parameters carried forward from prior
functions in the chain (ignore)}

\item{...}{Expressions to evaluate}
}
\description{
This function is used to filter the downloaded scorecard data. It
converts idiomatic R into the format required by the API call.
}
\examples{
\dontrun{
sc_filter(region == 1) # New England institutions
sc_filter(stabbr == c('TN','KY')) # institutions in Tennessee and Kentucky
sc_filter(control != 3) # exclude private, for-profit institutions
sc_filter(control == c(1,2)) # same as above
sc_filter(control == 1:2) # same as above
sc_filter(stabbr == 'TN', control == 1, locale == 41:43) # TN rural publics
}
}
