% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embase_retrieval.R
\name{embase_retrieval}
\alias{embase_retrieval}
\title{SCOPUS Embase Retrieval}
\usage{
embase_retrieval(id, identifier = c("lui", "pii", "doi", "embase",
  "pubmed_id", "medline"), http_end = NULL, ...)
}
\arguments{
\item{id}{Identifier for abstract}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an Embase Entry from the Elsevier Embase Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = embase_retrieval("S1053811915002700", identifier = "pii")
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}
