% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/author_retrieval.R
\name{author_retrieval}
\alias{author_retrieval}
\title{SCOPUS Author Retrieval}
\usage{
author_retrieval(id, identifier = c("author_id", "eid"), http_end = NULL,
  ...)
}
\arguments{
\item{id}{Identifier for author}

\item{identifier}{Type of identifier to use}

\item{http_end}{any additional end to http statement.
See \code{\link{generic_elsevier_api}}}

\item{...}{Arguments to be passed to \code{\link{generic_elsevier_api}}}
}
\value{
List of elements, similar to \code{\link{generic_elsevier_api}}
}
\description{
This function wraps \code{\link{generic_elsevier_api}} to give a
retrieval of an author from the Elsevier Author Retrieval API
}
\examples{
api_key = get_api_key(NULL, error = FALSE)
if (!is.null(api_key)){
   x = author_retrieval("40462056100", identifier = "author_id")
} else {
 x = author_retrieval(
 "40462056100",
 identifier = "author_id",
   api_key_error = FALSE)
}
}
\seealso{
\code{\link{generic_elsevier_api}}
}

