% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelSample.R
\name{labelSample}
\alias{labelSample}
\title{labelSample}
\usage{
labelSample(x, y, nr.points = 1, nr.pixels = NULL, agg.radius = NULL)
}
\arguments{
\item{x}{Object of class \emph{SpatialPoints} of \emph{SpatialPointsDataFrame}.}

\item{y}{Pixel resolution or a valid raster layer.}

\item{nr.points}{Minimum number of observations per pixel.}

\item{nr.pixels}{Minimum number of pixels per region.}

\item{agg.radius}{Minimum radius for pixel aggregation. Unit depends on the projection of the data.}
}
\value{
A numeric \emph{vector} with region identifiers for each observation in \emph{x} to their correspondent pixel region. Filtered observations are returned as \emph{NA}.
}
\description{
{Pixel-based labeling of spatially connected groups of points in a \emph{SpatialPoints} object.}
}
\details{
{First, the observations are converted to pixel coordinates and pixels with a corresponding number of observations greater than \emph{nr.points}
are filtered out. Then, if \emph{nr.pixels} is set, the function evaluates the spatial connectivity of the pixels and regions with a pixel count smaller
than \emph{nr.pixels} are filtered out. Then, the algorithm aggregates nearby regions within the distance specified by \emph{agg.radius}. The final region
identifiers are then assigned back to the original observations in \emph{x} based on their corresponding pixel coordinates. This analysis is based on the spatial
extent of \emph{x} and a given pixel resolution (\emph{y}). Alternatively, the user may assign a raster object as \emph{y} assuring that the
final output is aligned with it.}
}
\examples{
{

 require(raster)

 # read raster data
 r <- raster(system.file('extdata', '2013-07-16_ndvi.tif', package="rsMove"))

 # read movement data
 data(shortMove)

 # derive region labels
 labels <- labelSample(shortMove, r, agg.radius=60)

}
}
\seealso{
\code{\link{sampleMove}} \code{\link{hotMove}}
}
