% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleMove.R
\name{sampleMove}
\alias{sampleMove}
\title{sampleMove}
\usage{
sampleMove(xy = xy, obs.time = obs.time, search.radius = search.radius,
  method = "m", tUnit = NULL)
}
\arguments{
\item{xy}{Object of class \emph{SpatialPoints} or \emph{SpatialPointsDataFrame}.}

\item{obs.time}{Object of class \emph{Date}, \emph{POSIXlt} or \emph{POSIXct} with the same length as \emph{xy}.}

\item{search.radius}{Sample search radius (in meters).}

\item{method}{How should the distance be estimated? One of 'm' or 'deg'. Default is 'm'.}

\item{tUnit}{Time unit to estimate elapsed time. See \code{\link[base]{difftime}} for keywords. Default is \emph{mins}.}
}
\value{
A \emph{SpatialPointsDataFrame} with a reduced sample set.
}
\description{
Remote sensing oriented sampling of stops along a movement track.
}
\details{
{This function finds location where an animal showed little or no movement based on GPS tracking data.
It looks at the distance among consecutive samples and places pointer when the distance is bellow the defined
threshold (\emph{search.radius}). When a pointer is found, the function looks at the distance between the pointer and
the following samples. While this is below the distance threshold, the samples are assigned to the same segment.
Then, for each segment, the function summarizes the corresponding samples deriving mean coordinates, the start,
end and total time spent and the total number of samples per segment ('count'). The user should selected \emph{method}
in accordance with the projection system associated to the data. If 'm' it bases this analysis on the the ecludian distance.
However, if 'deg' it set, the function uses the haversine formula.}
}
\examples{
{

 require(raster)

# reference data
data(longMove)

 # sampling without reference grid
 obs.time = strptime(longMove$timestamp, "\%Y-\%m-\%d \%H:\%M:\%S")
 output <- sampleMove(xy=longMove, obs.time=obs.time, search.radius=7, method='deg')

 # compare original vs new samples
 plot(longMove, col="black", pch=16)
 points(output$x, output$y, col="red", pch=15)

}
}
\seealso{
\code{\link{labelSample}} \code{\link{backSample}} \code{\link{dataQuery}}
}
