% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsComposite.R
\name{rsComposite}
\alias{rsComposite}
\title{rsComposite}
\usage{
rsComposite(img, rd, ot, cm = 1, type = "norm", d.buffer = NULL)
}
\arguments{
\item{img}{Object of class \emph{RasterSpack} or \emph{RasterBrick}.}

\item{rd}{Object of class \emph{Date} with \emph{img} observation dates.}

\item{ot}{Object of class \emph{Date} with reference dates.}

\item{cm}{Number of deviations from the target date. Default is 1.}

\item{type}{One of "norm" or "pheno" or "pheno2".}

\item{d.buffer}{Search buffer (expressed in days).}
}
\value{
A \emph{list}.
}
\description{
Compositing of remote sensing data based on GPS tracking dates.
}
\details{
{The function uses a multi-layer raster object to build a composite.
It looks at a ginve set of dates (e.g. GPS tracking dates) and estimates a
reference date to build the composite for defined by the median of \emph{ot}.
The median is then used to estimate Median Absolute Deviation (MAD) which
specifies the size of the buffer set aroung the target date within which
bands will be considered. Here, \emph{cm} is used as a multiplier to enlarge
the temporal buffer. Alternatively, a user define temporal buffer is allowed
by using the keyword \emph{d.buffer}. If \emph{ot} countains only one element,
the function will use it as a reference date. In this case, if \emph{d.buffer}
is NULL the function will set it to 30 by default. The way how the function handles
temporal information depends on the \emph{type} keyword. If set to \emph{norm},
the function will search for the nearest possible dates within the temporal
buffer. However, if \emph{pheno} is set, then the day of the year will be given
priority. Thus, if multi-year raster data is provided, older data with a DOY
closer to the target that will be used when possible. The output provides:
#' \itemize{
 \item{\emph{value} - composite of target images}
 \item{\emph{dates} - per pixel date code}
 \item{\emph{count} - pixel count of \emph{dates}}
 \item{\emph{na.count} - count of NA values}
 \item{\emph{target} - target date}
 \item{\emph{mad} - temporal buffer}}
 If \emph{pheno2} is used, for each pixel, the function wilhin estimate a weighted
 mean of the clear pixels within the temporal buffer. The weights represent the
 inverse time difference between the target and the available dates giver higher
 weights to small differences.}
}
\examples{
\dontrun{

 require(raster)

 # read raster data
 file <- list.files(system.file('extdata', '', package="rsMove"), 'tc.*tif', full.names=TRUE)
 rsStk <- stack(file)
 rsStk <- stack(rsStk, rsStk, rsStk) # dummy files for the example

 # raster dates
 rd = seq.Date(as.Date("2013-01-01"), as.Date("2013-12-31"), 45)

 # target date
 ot = as.Date("2013-06-01")

 # build composite
 r.comp <- rsComposite(rsStk, rd, ot, d.buffer=90)

}
}
\seealso{
\code{\link{imgInt}} \code{\link{dataQuery}} \code{\link{proSat}}
}
