% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly2sample.R
\name{poly2sample}
\alias{poly2sample}
\title{poly2sample}
\usage{
poly2sample(pol = pol, re = NULL, mpc = NULL, pr = NULL)
}
\arguments{
\item{pol}{Object of class \emph{SpatialPolygons} or \emph{SpatialPolygonDataFrame}.}

\item{re}{Object of class \emph{Extent} or a raster object from which an extent can be derived.}

\item{mpc}{Minimum pixel cover (0-100). Default is 100.}

\item{pr}{Pixel resolution.}
}
\value{
A \emph{SpatialPointsDataFrame}.
}
\description{
Convert spatial polygons into point samples.
}
\details{
{Determines coordinates of pixels within a given extent. If \emph{re} is missing the
           target extent corresponds to the extent of the polygon layer. In this case, \emph{pr}
           is required. If \emph{re} is an \emph{Extent} object or \emph{re} is missing \emph{rp} is required. 
           \emph{mpc} can be used to filter pixels with low purity, i.e. pixels where the 
           percentage of area cover by a polygon is below the defined threshold. 
           The output provides the coordinates (\emph{x} and \emph{y}) the 
           pixel percent cover (\emph{cover}) for each selected pixel.}
}
\examples{
{
 
 require(rgdal)
 require(raster)
 require(sp)
 
 # load example probability image
 file <- system.file('extdata', 'konstanz_probabilities.tif', package="rsMove")
 img <- raster(file)
 
 # load area of interest
 file <- system.file('extdata', 'konstanz_roi.shp', package="rsMove")
 roi <- shapefile(file)
 
 # segment probabilities
 samples <- poly2sample(pol=roi, re=img)
 
}
}
\seealso{
\code{\link{dataQuery}} \code{\link{imgInt}}
}
