% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssvd.R
\name{rssvd}
\alias{rssvd}
\title{Reduced-rank regression with a sparse singular value decomposition}
\usage{
rssvd(Y, X, nrank, ic.type = c("BIC", "BICP", "AIC"), orthX = FALSE,
      control = list(), screening = FALSE)
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{nrank}{integer specification of the desired rank}

\item{ic.type}{character specifying which information criterion to use to
select the best: `BIC', `BICP', and `AIC'}

\item{orthX}{logical indicating if X is orthogonal, in which case a faster
algorithm is used}

\item{control}{a list of parameters controlling the fitting process}

\item{screening}{If TRUE, marginal screening via glm is performed before
srrr fitting.}
}
\value{
S3 \code{rssvd.path} object, a list consisting of
  \item{Upath}{solution path of U}
  \item{Vpath}{solution path of V}
  \item{Dpath}{solution path of D}
  \item{U}{estimated left singular matrix that is orthogonal}
  \item{V}{estimated right singular matrix that is orthogonal}
  \item{D}{estimated singular values such that C=UDVt}
  \item{rank}{estimated rank}
}
\description{
Reduced-rank regression with a sparse singular value decomposition using the
iterative exclusive extraction algorithm.
}
\details{
The model fitting can be controled through argument \code{control}.
The available elements include
\itemize{
    \item{maxit}: maximum number of iterations.
    \item{epsilon}: convergence tolerance.
    \item{innerMaxit}: maximum number of iterations for inner steps.
    \item{innerEpsilon}: convergence tolerance for inner steps.
    \item{nlambda}: number of tuning parameters.
    \item{adaptive}: if Ture, use adaptive penalization.
    \item{gamma0}: power parameter for constructing adaptive weights.
    \item{minLambda}: multiplicate factor to determine the minimum lambda.
    \item{niter.eea}: the number of iterations in the iterative exclusive
extraction algorithm.
    \item{df.tol}: tolerance.
}
}
\examples{
library(rrpack)
## Simulate data from a sparse factor regression model
p <- 50; q <- 50; n <- 100; nrank <- 3
mydata <- rrr.sim1(n, p, q, nrank, s2n = 1, sigma = NULL,
                   rho_X = 0.5, rho_E = 0.3)
fit1 <- with(mydata, rssvd(Y, X, nrank = nrank + 1))
summary(fit1)
plot(fit1)
}
\references{
Chen, K., Chan, K.-S. and Stenseth, N. C. (2012) Reduced rank stochastic
regression with a sparse singular value decomposition.  \emph{Journal of the
Royal Statistical Society: Series B}, 74, 203--221.
}
