/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import nbl.utilj.StringUtil;
import rreval.AppCmd;
import rreval.ConnectionJ;
import rreval.ConnectionR;
import rreval.Message;
import rreval.MessageType;
import rreval.RReServerApp;
import rreval.Verbose;
import rreval.WriteException;

public class ServerMessageHandler
implements Runnable {
    public static final String CLOSE_CON = "closeServerConnection";
    public static final String CMD_TEST = "testCmdServerApp";
    RReServerApp parentApp;
    ConnectionR conR;
    ConnectionJ conJ;
    boolean handleMessages;
    boolean keepRunning;

    public ServerMessageHandler(RReServerApp parentApp, ConnectionR conR, ConnectionJ conJ, boolean handleMessages) {
        this.parentApp = parentApp;
        this.conR = conR;
        this.conJ = conJ;
        this.handleMessages = handleMessages;
    }

    @Override
    public void run() {
        this.keepRunning = true;
        while (this.keepRunning) {
            try {
                Verbose.show("... waiting for message");
                Message m = (Message)this.conJ.readMessage();
                if (this.handleMessages) {
                    if (m.isMessageToR() || m.isRReServerCmd()) {
                        try {
                            this.sendMessageToRRevalServer(m);
                        }
                        catch (Exception x) {
                            this.sendErrorMessageJ(x);
                        }
                        continue;
                    }
                    if (m.isAppCmd()) {
                        try {
                            this.handleCommand(m);
                        }
                        catch (Exception x) {
                            this.sendErrorMessageJ(x);
                        }
                        continue;
                    }
                    this.conJ.writeMessage(this.createWrongTypeErrorMessage(m));
                    continue;
                }
                if (m.isConnectCmdMessage()) {
                    try {
                        this.conJ.writeMessage(Message.createRReServerNotAvailableMessage());
                        this.conJ.close();
                    }
                    catch (Exception nx) {
                        System.err.println(StringUtil.toString((Throwable)nx));
                    }
                    this.keepRunning = false;
                    continue;
                }
                this.conJ.writeMessage(new Message(MessageType.rj, "RReServerApp received unexpected message: " + m.obj.toString()));
            }
            catch (Exception xxx) {
                Verbose.show("ServerSideConduit.run(): ", xxx);
            }
        }
    }

    void handleCommand(Message m) throws Exception {
        Verbose.show("server...handleCommand() m=" + m);
        AppCmd ac = new AppCmd(m.obj);
        if (m.isConnectCmdMessage()) {
            this.parentApp.connectedToClient = true;
            this.conJ.writeMessage(Message.createConnectedToRReServerMessage());
        } else if (m.isDisonnectCmdMessage()) {
            this.keepRunning = false;
            this.conJ.close();
            this.parentApp.connectedToClient = false;
        } else {
            this.conJ.writeMessage(new Message(MessageType.rj, "RReServer received unexpected message=" + m.obj.toString()));
        }
    }

    void sendMessageToRRevalServer(Message m) throws Exception {
        try {
            this.conR.writeMessage(m);
        }
        catch (Exception x) {
            throw this.writeEx("Error writing to rrevalServer: ", x);
        }
        Verbose.show("ServerMessageHandler sent message to R server.");
        Message r = this.conR.readMessage();
        try {
            this.conJ.writeMessage(r);
        }
        catch (Exception x) {
            throw this.writeEx("Error writing to conduit: ", x);
        }
        Verbose.show("ServerMessageHandler sent server reply back to conduit.");
    }

    public void close() {
        if (this.conJ != null) {
            this.conJ.close();
        }
        if (this.conR != null) {
            this.conR.close();
        }
        this.keepRunning = false;
    }

    WriteException writeEx(String s, Exception x) {
        return new WriteException(s + " " + StringUtil.getExceptionMessage((Throwable)x));
    }

    void sendErrorMessageJ(Exception x) {
        try {
            Verbose.show("Sending err m from ServerSideConduit: ", x);
            this.conJ.writeMessage(new Message(MessageType.er, StringUtil.getExceptionMessage((Throwable)x)));
        }
        catch (Exception z) {
            System.out.println(StringUtil.getExceptionMessage((Throwable)z));
        }
    }

    Message createWrongTypeErrorMessage(Message m) {
        String typeS = m != null ? (m.type != null ? m.type.toString() : "null type") : "null message";
        return new Message(MessageType.er, "Error: undefined or inapproriate message type=" + typeS);
    }
}

