% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_ibd.R
\name{ibd.marker}
\alias{ibd.marker}
\title{Score IBD sharing at a list of marker positions.}
\usage{
ibd.marker(inheritance, marker, ind1index, ind2index = NULL,
  relatedness = TRUE)
}
\arguments{
\item{inheritance}{list of numeric matrices.}

\item{marker}{numeric vector.}

\item{ind1index, ind2index}{positive integer, represents index of individual in pedigree.}

\item{relatedness}{logical, determines coding of IBD information.}
}
\value{
A numeric vector of IBD sharing status at the list of marker positions.
}
\description{
\code{ibd.marker} determines pairwise IBD sharing at marker positions.
}
\details{
When only index of one individual is supplied, IBD sharing status at each marker is coded as 0 (not IBD) or 1 (IBD) between the two haplotypes of the individual.

When indices of two individuals are supplied, IBD sharing status at each marker is either in relatedness (default) or alphanumeric IBD state, where recoding can be done using \code{\link{recode.ibd}}.
}
\examples{
# a simple pedigree with sibling marriage
pedigree = as.character(rep(1, 5))
member = as.character(c(11, 12, 21, 22, 31))
sex = as.numeric(c(1, 2, 1, 2, 1))
father = as.character(c(NA, NA, 11, 11, 21))
mother = as.character(c(NA, NA, 12, 12, 22))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)
inheritance = sim.recomb(pedinfo, 100)
nsnp = 10
marker = sort(runif(nsnp, 0, 100))

# IBD at markers between the two haplotypes of the inbred individual
ibd.marker(inheritance, marker, 5)

# IBD at markers between the two full sibs, with different IBD coding
ibd.marker(inheritance, marker, 3, 4) # relatedness
ibd.marker(inheritance, marker, 3, 4, relatedness = FALSE) # alphanumeric IBD state
}
