/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.n3.IRIResolver;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandler;
import com.hp.hpl.jena.sparql.core.describe.DescribeHandlerRegistry;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.ResultSetStream;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.engine.binding.BindingRoot;
import com.hp.hpl.jena.sparql.engine.binding.BindingUtils;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.Template;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.DatasetUtils;
import com.hp.hpl.jena.sparql.util.ModelUtils;
import com.hp.hpl.jena.sparql.util.graph.GraphFactory;
import com.hp.hpl.jena.util.FileManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openjena.atlas.logging.Log;

public class QueryExecutionBase
implements QueryExecution {
    private Query query;
    private Dataset dataset;
    private QueryEngineFactory qeFactory;
    private QueryIterator queryIterator = null;
    private Plan plan = null;
    private Context context;
    private FileManager fileManager = FileManager.get();
    private QuerySolution initialBinding = null;

    public QueryExecutionBase(Query query2, Dataset dataset, Context context, QueryEngineFactory qeFactory) {
        this.query = query2;
        this.dataset = dataset;
        this.context = context;
        this.qeFactory = qeFactory;
    }

    public void abort() {
        if (this.queryIterator != null) {
            this.queryIterator.abort();
        }
    }

    public void close() {
        if (this.queryIterator != null) {
            this.queryIterator.close();
        }
        if (this.plan != null) {
            this.plan.close();
        }
    }

    public ResultSet execSelect() {
        if (!this.query.isSelectType()) {
            throw new QueryExecException("Attempt to have ResultSet from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        return this.execResultSet();
    }

    public Model execConstruct() {
        return this.execConstruct(GraphFactory.makeJenaDefaultModel());
    }

    public Model execConstruct(Model model) {
        if (!this.query.isConstructType()) {
            throw new QueryExecException("Attempt to get a CONSTRUCT model from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setQueryResultStar(true);
        this.startQueryIterator();
        this.insertPrefixesInto(model);
        Template template = this.query.getConstructTemplate();
        while (this.queryIterator.hasNext()) {
            HashSet<Triple> set = new HashSet<Triple>();
            HashMap<Node, Node> bNodeMap = new HashMap<Node, Node>();
            Binding binding = this.queryIterator.nextBinding();
            template.subst(set, bNodeMap, binding);
            for (Triple t : set) {
                Statement stmt = ModelUtils.tripleToStatement(model, t);
                if (stmt == null) continue;
                model.add(stmt);
            }
        }
        this.close();
        return model;
    }

    public Model execDescribe() {
        return this.execDescribe(GraphFactory.makeJenaDefaultModel());
    }

    public Model execDescribe(Model model) {
        if (!this.query.isDescribeType()) {
            throw new QueryExecException("Attempt to get a DESCRIBE result from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.query.setResultVars();
        if (this.query.getQueryPattern() == null) {
            this.query.setQueryPattern(new ElementGroup());
        }
        HashSet<RDFNode> set = new HashSet<RDFNode>();
        ResultSet qRes = this.execResultSet();
        this.insertPrefixesInto(model);
        if (qRes != null) {
            while (qRes.hasNext()) {
                QuerySolution rb = qRes.nextSolution();
                for (String varName : this.query.getResultVars()) {
                    RDFNode n = rb.get(varName);
                    set.add(n);
                }
            }
            this.close();
        }
        if (this.query.getResultURIs() != null) {
            for (Node n : this.query.getResultURIs()) {
                RDFNode rNode = ModelUtils.convertGraphNodeToRDFNode(n, this.dataset.getDefaultModel());
                set.add(rNode);
            }
        }
        List<DescribeHandler> dhList = DescribeHandlerRegistry.get().newHandlerList();
        this.getContext().put(ARQConstants.sysCurrentDataset, this.getDataset());
        for (DescribeHandler dh : dhList) {
            dh.start(model, this.getContext());
        }
        for (RDFNode n : set) {
            if (!(n instanceof Resource)) continue;
            for (DescribeHandler dh : dhList) {
                dh.describe((Resource)n);
            }
        }
        for (DescribeHandler dh : dhList) {
            dh.finish();
        }
        this.close();
        return model;
    }

    public boolean execAsk() {
        if (!this.query.isAskType()) {
            throw new QueryExecException("Attempt to have boolean from a " + QueryExecutionBase.labelForQuery(this.query) + " query");
        }
        this.startQueryIterator();
        boolean r = this.queryIterator.hasNext();
        this.close();
        return r;
    }

    protected void execInit() {
    }

    private ResultSet asResultSet(QueryIterator qIter) {
        Model model = null;
        model = this.dataset != null ? this.dataset.getDefaultModel() : ModelFactory.createDefaultModel();
        ResultSetStream rStream = new ResultSetStream(this.query.getResultVars(), model, qIter);
        return rStream;
    }

    private void startQueryIterator() {
        this.execInit();
        if (this.queryIterator != null) {
            Log.warn(this, "Query iterator has already been started");
        }
        this.queryIterator = this.getPlan().iterator();
    }

    private ResultSet execResultSet() {
        this.startQueryIterator();
        return this.asResultSet(this.queryIterator);
    }

    public Plan getPlan() {
        if (this.plan == null) {
            DatasetGraph dsg = QueryExecutionBase.prepareDataset(this.dataset, this.query, this.fileManager);
            Binding inputBinding = null;
            if (this.initialBinding != null) {
                inputBinding = new BindingMap();
                BindingUtils.addToBinding(inputBinding, this.initialBinding);
            }
            if (inputBinding == null) {
                inputBinding = BindingRoot.create();
            }
            this.plan = this.qeFactory.create(this.query, dsg, inputBinding, this.getContext());
        }
        return this.plan;
    }

    private void insertPrefixesInto(Model model) {
        try {
            if (this.dataset != null) {
                Model m = this.dataset.getDefaultModel();
                model.setNsPrefixes((PrefixMapping)m);
            }
            model.setNsPrefixes(this.query.getPrefixMapping());
        }
        catch (Exception ex) {
            Log.warn(this, "Exception in insertPrefixes: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static String labelForQuery(Query q) {
        if (q.isSelectType()) {
            return "SELECT";
        }
        if (q.isConstructType()) {
            return "CONSTRUCT";
        }
        if (q.isDescribeType()) {
            return "DESCRIBE";
        }
        if (q.isAskType()) {
            return "ASK";
        }
        return "<<unknown>>";
    }

    public Context getContext() {
        return this.context;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private static DatasetGraph prepareDataset(Dataset dataset, Query query2, FileManager fileManager) {
        if (dataset != null) {
            return dataset.asDatasetGraph();
        }
        if (!query2.hasDatasetDescription()) {
            throw new QueryExecException("No dataset description for query");
        }
        String baseURI = query2.getBaseURI();
        if (baseURI == null) {
            baseURI = IRIResolver.chooseBaseURI();
        }
        DatasetGraph dsg = DatasetUtils.createDatasetGraph(query2.getGraphURIs(), query2.getNamedGraphURIs(), fileManager, baseURI);
        return dsg;
    }

    public void setFileManager(FileManager fm) {
        this.fileManager = fm;
    }

    public void setInitialBinding(QuerySolution startSolution) {
        this.initialBinding = startSolution;
    }

    public void setInitialBindings(ResultSet table) {
        throw new UnsupportedOperationException("setInitialBindings(ResultSet)");
    }
}

