/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.json.io.parser;

import org.openjena.atlas.json.io.JSONHandler;
import org.openjena.atlas.json.io.parser.ParserBase;
import org.openjena.atlas.json.io.parser.TokenizerJSON;
import org.openjena.riot.tokens.TokenType;

public class JSONP
extends ParserBase {
    private JSONHandler maker;

    public JSONP(TokenizerJSON tokens2, JSONHandler maker) {
        super(tokens2);
        this.maker = maker;
    }

    public void parse() {
        if (!this.token().hasType(TokenType.LBRACE)) {
            this.exception("Not a JSON object START: " + this.token(), new Object[0]);
        }
        this.parseObject();
    }

    private void parseObject() {
        this.maker.startObject();
        this.move();
        if (this.lookingAt(TokenType.RBRACE)) {
            this.move();
            this.maker.finishObject();
            return;
        }
        while (true) {
            this.maker.startPair();
            if (!this.lookingAt(TokenType.KEYWORD) && !this.lookingAtString()) {
                this.exception("Not a key for a JSON object: " + this.token(), new Object[0]);
            }
            String key = this.token().getImage();
            this.move();
            this.maker.valueString(key);
            if (!this.lookingAt(TokenType.COLON)) {
                this.exception("Not a colon: " + this.token(), new Object[0]);
            }
            this.move();
            this.maker.keyPair();
            this.parseAny();
            this.maker.finishPair();
            if (!this.lookingAt(TokenType.COMMA)) break;
            this.move();
        }
        if (!this.lookingAt(TokenType.RBRACE)) {
            this.exception("Illegal: " + this.token(), new Object[0]);
        }
        this.move();
        this.maker.finishObject();
    }

    public void parseAny() {
        switch (this.token().getType()) {
            case LBRACE: {
                this.parseObject();
                return;
            }
            case LBRACKET: {
                this.parseArray();
                return;
            }
            case INTEGER: {
                this.maker.valueInteger(this.token().getImage());
                this.move();
                return;
            }
            case DECIMAL: {
                this.maker.valueDecimal(this.token().getImage());
                this.move();
                return;
            }
            case DOUBLE: {
                this.maker.valueDouble(this.token().getImage());
                this.move();
                return;
            }
            case STRING1: 
            case STRING2: 
            case LONG_STRING1: 
            case LONG_STRING2: {
                this.maker.valueString(this.token().getImage());
                this.move();
                return;
            }
            case KEYWORD: {
                String image = this.token().getImage();
                if (image.equalsIgnoreCase("true")) {
                    this.maker.valueBoolean(true);
                    this.move();
                    return;
                }
                if (image.equalsIgnoreCase("false")) {
                    this.maker.valueBoolean(false);
                    this.move();
                    return;
                }
                if (image.equalsIgnoreCase("null")) {
                    this.maker.valueNull();
                    this.move();
                    return;
                }
                this.maker.valueString(image);
                break;
            }
            default: {
                this.exception("Unrecognized token: " + this.token(), new Object[0]);
            }
        }
    }

    private void parseArray() {
        this.maker.startArray();
        this.move();
        if (this.lookingAt(TokenType.RBRACKET)) {
            this.move();
            this.maker.finishArray();
            return;
        }
        while (true) {
            this.parseAny();
            this.maker.element();
            if (!this.lookingAt(TokenType.COMMA)) break;
            this.move();
        }
        if (!this.lookingAt(TokenType.RBRACKET)) {
            this.exception("Illegal: " + this.token(), new Object[0]);
        }
        this.move();
        this.maker.finishArray();
    }
}

