/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.syntax;

import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementBind;
import com.hp.hpl.jena.sparql.syntax.ElementDataset;
import com.hp.hpl.jena.sparql.syntax.ElementExists;
import com.hp.hpl.jena.sparql.syntax.ElementFetch;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementMinus;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementNotExists;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementPathBlock;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementSubQuery;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.syntax.ElementVisitor;

public class ElementWalker {
    public static void walk(Element el, ElementVisitor visitor) {
        ElementWalker.walk(el, new Walker(visitor), visitor);
    }

    public static void walk(Element el, Walker walker, ElementVisitor visitor) {
        el.visit(walker);
    }

    public static class Walker
    implements ElementVisitor {
        protected ElementVisitor proc;

        protected Walker(ElementVisitor visitor) {
            this.proc = visitor;
        }

        public void visit(ElementTriplesBlock el) {
            this.proc.visit(el);
        }

        public void visit(ElementFilter el) {
            this.proc.visit(el);
        }

        public void visit(ElementAssign el) {
            this.proc.visit(el);
        }

        public void visit(ElementBind el) {
            this.proc.visit(el);
        }

        public void visit(ElementUnion el) {
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementGroup el) {
            for (Element e2 : el.getElements()) {
                e2.visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementOptional el) {
            if (el.getOptionalElement() != null) {
                el.getOptionalElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementDataset el) {
            if (el.getPatternElement() != null) {
                el.getPatternElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementNamedGraph el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementService el) {
            if (el.getElement() != null) {
                el.getElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementFetch el) {
            this.proc.visit(el);
        }

        public void visit(ElementExists el) {
            this.proc.visit(el);
        }

        public void visit(ElementNotExists el) {
            this.proc.visit(el);
        }

        public void visit(ElementMinus el) {
            if (el.getMinusElement() != null) {
                el.getMinusElement().visit(this);
            }
            this.proc.visit(el);
        }

        public void visit(ElementSubQuery el) {
            this.proc.visit(el);
        }

        public void visit(ElementPathBlock el) {
            this.proc.visit(el);
        }
    }
}

