/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingMap;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderLib;
import com.hp.hpl.jena.sparql.sse.builders.BuilderNode;
import com.hp.hpl.jena.sparql.util.FmtUtils;

public class BuilderBinding {
    public static Binding build(Item item) {
        BuilderLib.checkList(item, "Attempt to build a binding from non-list: " + item);
        return BuilderBinding.buildBinding(item.getList());
    }

    private static Binding buildBinding(ItemList list) {
        Item head;
        if (list.size() == 0) {
            BuilderLib.broken(list, "Empty list");
        }
        if (!(head = list.get(0)).isSymbolIgnoreCase("row") && !head.isSymbolIgnoreCase("binding")) {
            BuilderLib.broken((ItemLocation)list, "Does not start (row ...) or (binding ...)", head);
        }
        BindingMap binding = new BindingMap();
        for (int i = 1; i < list.size(); ++i) {
            Item item = list.get(i);
            BuilderLib.checkList(item, "Attempt to build a binding pair from non-list: " + item);
            ItemList pair = item.getList();
            BuilderLib.checkLength(2, pair, "Need a pair for a binding");
            Var v = BuilderNode.buildVar(pair.get(0));
            Item cdr = pair.get(1);
            if (cdr.isSymbolIgnoreCase("undef") || cdr.isSymbolIgnoreCase("null")) continue;
            BuilderLib.checkNode(cdr);
            Node node = BuilderNode.buildNode(item.getList().get(1));
            if (node == null) {
                BuilderLib.broken(item.getList().get(1), "Null node from " + item.getList().get(1));
            }
            if (node.isVariable()) {
                BuilderLib.broken(item.getList().get(1), "No variables as table values: " + FmtUtils.stringForNode(node));
            }
            if (!node.isConcrete()) {
                BuilderLib.broken(item.getList().get(1), "Ony concrete nodes as table values: " + FmtUtils.stringForNode(node));
            }
            binding.add(v, node);
        }
        return binding;
    }
}

