/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.expr.ExprException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.nodevalue.NodeValueVisitor;

public class NodeValueGYear
extends NodeValue {
    XSDDateTime date;

    public NodeValueGYear(XSDDateTime dt) {
        this.date = dt;
        if (dt.getTimePart() != 0.0) {
            throw new ExprException("Illegal date: " + dt);
        }
    }

    public NodeValueGYear(XSDDateTime dt, Node n) {
        super(n);
        this.date = dt;
    }

    public boolean isGYear() {
        return true;
    }

    public XSDDateTime getDateTime() {
        return this.date;
    }

    protected Node makeNode() {
        String lex = this.date.toString();
        return Node.createLiteral((String)lex, null, (RDFDatatype)XSDDatatype.XSDgYear);
    }

    public void visit(NodeValueVisitor visitor) {
        visitor.visit(this);
    }
}

