/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.builtins;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import java.util.Iterator;
import java.util.List;

public class ListEqual
extends BaseBuiltin {
    public String getName() {
        return "listEqual";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        this.checkArgs(length, context);
        Node n0 = this.getArg(0, args, context);
        Node n1 = this.getArg(1, args, context);
        return ListEqual.listEqual(n0, n1, context);
    }

    protected static boolean listEqual(Node list1, Node list2, RuleContext context) {
        List<Node> elts1 = Util.convertList(list1, context);
        List<Node> elts2 = Util.convertList(list2, context);
        if (elts1.size() != elts2.size()) {
            return false;
        }
        for (Node elt : elts1) {
            boolean matched = false;
            Iterator<Node> j = elts2.iterator();
            while (j.hasNext()) {
                Node elt2 = j.next();
                if (!elt.sameValueAs(elt2)) continue;
                j.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

