% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{rdasim1}
\alias{rdasim1}
\title{Generate simulated data for Ridge Redundancy Analysis (RDA).}
\usage{
rdasim1(n, p, q, k, s2n = c(5, 5))
}
\arguments{
\item{n}{The number of samples.}

\item{p}{The number of variables of X.}

\item{q}{The number of variables of Y.}

\item{k}{The number of latent variables.}

\item{s2n}{The numeric parameters of signal to noise ratio for X and Y, default value is c(1,1).}
}
\value{
A list containing matrices X, Y, H, and theta.y.
}
\description{
The function generates simulated data for Ridge Redundancy Analysis (RDA). It creates two data matrices, X and Y, based on a set of shared latent variables H. The function adds noise to the data and returns a list containing the matrices X, Y, the latent variables H, and the regression coefficients theta.y used for generating Y.
}
\examples{
# Example usage of rdasim1
set.seed(10)
sim_data <- rdasim1(n = 10, p = 5, q = 3, k = 2)
str(sim_data)
}
