% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db_ops.R
\name{rq_copy_to}
\alias{rq_copy_to}
\title{Copy local R table to remote data handle.}
\usage{
rq_copy_to(
  db,
  table_name,
  d,
  ...,
  qualifiers = NULL,
  overwrite = FALSE,
  temporary = TRUE,
  rowidcolumn = NULL
)
}
\arguments{
\item{db}{database connection handle.}

\item{table_name}{name of table to create.}

\item{d}{data.frame to copy to database.}

\item{...}{force later argument to be by name}

\item{qualifiers}{optional named ordered vector of strings carrying additional db hierarchy terms, such as schema.}

\item{overwrite}{logical, if TRUE try to overwrite existing table.}

\item{temporary}{logical, if TRUE try to mark table as temporary.}

\item{rowidcolumn}{character, name to land row-ids.}
}
\value{
a relop representation of the data
}
\description{
Copy local R table to remote data handle.
}
\examples{

if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- rq_copy_to(db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))

  sql <- to_sql(d, db)
  cat(sql)
  print(DBI::dbGetQuery(db, "SELECT * FROM d"))
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{db_td}}, \code{\link{mk_td}}, \code{\link{materialize}}, \code{\link{execute}}, \code{\link{to_sql}}
}
