% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/work_with_NULLs.R
\name{mark_null_cols}
\alias{mark_null_cols}
\title{Indicate NULLs per row for given column set.}
\usage{
mark_null_cols(source, cols)
}
\arguments{
\item{source}{incoming rel_op tree or data.frame.}

\item{cols}{named character, values are columns to track, names are where to land indicators.}
}
\value{
rel_op node or data.frame (depending on input).
}
\description{
Build a query that creates NULL indicators for nulls in slected columns.
}
\examples{

# WARNING: example tries to change rquery.rquery_db_executor option to RSQLite and back.
if (requireNamespace("DBI", quietly = TRUE) && requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  RSQLite::initExtension(my_db)
  old_o <- options(list("rquery.rquery_db_executor" = list(db = my_db)))

  d <- rq_copy_to(my_db, 'd',
                   data.frame(AUC = c(0.6, 0.5, NA),
                              R2 = c(1.0, 0.9, NA)))
  op_tree <- d \%.>\% mark_null_cols(., qc(AUC_NULL, R2_NULL) \%:=\%
                                     qc(AUC, R2))
  cat(format(op_tree))
  sql <- to_sql(op_tree, my_db)
  cat(sql)
  print(DBI::dbGetQuery(my_db, sql))

  # ad-hoc mode
  data.frame(AUC=c(1,NA,0.5), R2=c(NA,1,0)) \%.>\%
     op_tree \%.>\%
     print(.)

  # cleanup
  options(old_o)
  DBI::dbDisconnect(my_db)
}

}
\seealso{
\code{\link{null_replace}}, \code{\link{count_null_cols}}
}
