% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgMakePts.R
\name{pgMakePts}
\alias{pgMakePts}
\alias{pgMakeStp}
\title{Add a POINT or LINESTRING geometry field.}
\usage{
pgMakePts(
  conn,
  name,
  colname = "geom",
  x = "x",
  y = "y",
  srid,
  index = TRUE,
  display = TRUE,
  exec = TRUE
)

pgMakeStp(
  conn,
  name,
  colname = "geom",
  x = "x",
  y = "y",
  dx = "dx",
  dy = "dy",
  srid,
  index = TRUE,
  display = TRUE,
  exec = TRUE
)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL schema and
table name (e.g., \code{name = c("schema","table")})}

\item{colname}{A character string specifying the name of the new
geometry column.}

\item{x}{The name of the x/longitude field.}

\item{y}{The name of the y/latitude field.}

\item{srid}{A valid SRID for the new geometry.}

\item{index}{Logical. Whether to create an index on the new
geometry.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}

\item{dx}{The name of the dx field (i.e. increment in x
direction).}

\item{dy}{The name of the dy field (i.e. increment in y
direction).}
}
\value{
If \code{exec = TRUE}, returns \code{TRUE} if the geometry
    field was successfully created.
}
\description{
Add a new POINT or LINESTRING geometry field.
}
\examples{
## Examples use a dummy connection from DBI package
conn <- DBI::ANSI()

## Create a new POINT field called 'pts_geom'
pgMakePts(conn, name = c("schema", "table"), colname = "pts_geom",
    x = "longitude", y = "latitude", srid = 4326, exec = FALSE)

## Create a new LINESTRING field called 'stp_geom'
pgMakeStp(conn, name = c("schema", "table"), colname = "stp_geom",
    x = "longitude", y = "latitude", dx = "xdiff", dy = "ydiff",
    srid = 4326, exec = FALSE)
}
\seealso{
The PostGIS documentation for \code{ST_MakePoint}:
    \url{http://postgis.net/docs/ST_MakePoint.html}, and for
    \code{ST_MakeLine}:
    \url{http://postgis.net/docs/ST_MakeLine.html}, which are the
    main functions of the call.
}
\author{
Mathieu Basille \email{mathieu@basille.org}
}
