% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetGeom.R
\name{pgGetPts}
\alias{pgGetPts}
\title{Load a PostGIS point geometry from a PostgreSQL table/view into R.}
\usage{
pgGetPts(
  conn,
  name,
  geom = "geom",
  gid = NULL,
  other.cols = "*",
  clauses = NULL
)
}
\value{
Spatial(Multi)PointsDataFrame or Spatial(Multi)Points
}
\description{
Load a PostGIS point geometry from a PostgreSQL table/view into R.
}
\examples{
\dontrun{
## Retrieve a SpatialPointsDataFrame with all data from table
## 'schema.tablename', with geometry in the column 'geom'
pgGetPts(conn, c("schema", "tablename"))
## Return a SpatialPointsDataFrame with columns c1 & c2 as data
pgGetPts(conn, c("schema", "tablename"), other.cols = "c1,c2")
## Return a SpatialPoints, retaining id from table as rownames
pgGetPts(conn, c("schema", "tablename"), gid = "table_id", other.cols = FALSE)
}
}
\author{
David Bucklin \email{david.bucklin@gmail.com}

Mathieu Basille \email{basille@ufl.edu}
}
\keyword{internal}
