% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_text.R
\name{search_text}
\alias{search_text}
\title{Text search for uuids}
\usage{
search_text(text, options = "string", simplify = TRUE, ...)
}
\arguments{
\item{text}{(character) Search string, see examples}

\item{options}{(character) See here for options}

\item{simplify}{(logical) Simplify result}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list. You always get back the UUID, and any other
fields requested.
}
\description{
Text search for uuids
}
\details{
These aren't necessarily ones with images though.
See examples
}
\examples{
\dontrun{
search_text(text = "Homo sapiens")
search_text(text = "Homo sapiens", options = "names")
search_text(text = "Homo sapiens", options = "type")
search_text(text = "Homo sapiens", options = "namebankID")
search_text(text = "Homo sapiens", options = "root")
search_text(text = "Homo sapiens", options = "uri")
search_text(text = "Homo sapiens", options = c("string","type","uri"))
search_text(text = "Homo sapiens", options = c("string","type","uri"), 
  simplify=FALSE) 

# pass in curl options
search_text(text = "Homo sapiens", options = "names", verbose = TRUE)
}
}
